/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.addons.testbench.junit5.pageobject;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.rapidpm.dependencies.core.logger.HasLogger;
import org.rapidpm.frp.functions.CheckedExecutor;
import org.rapidpm.frp.matcher.Case;
import org.rapidpm.frp.model.Result;
import org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.HasContainerInfo;
import org.rapidpm.vaadin.addons.webdriver.HasDriver;
import org.rapidpm.vaadin.addons.webdriver.WebDriverFunctions;

public interface PageObject
extends HasContainerInfo,
HasDriver,
HasLogger {
    default public void loadPage() {
        String url = this.url().get();
        this.logger().info("Navigate browser to " + url);
        this.getDriver().get(url);
    }

    default public void loadPage(String route) {
        String url = this.url().get();
        this.logger().info("Navigate browser to " + url + route);
        this.getDriver().get(url + route);
    }

    default public String getTitle() {
        return this.getDriver().getTitle();
    }

    default public BiFunction<String, String, String> property() {
        return (key, defaultValue) -> (String)System.getProperties().getOrDefault(key, defaultValue);
    }

    default public Supplier<String> protocol() {
        return () -> this.property().apply("server.protocol", "http");
    }

    default public Supplier<String> ip() {
        return () -> this.getContainerInfo().getHost();
    }

    default public Supplier<String> port() {
        return () -> String.valueOf(this.getContainerInfo().getPort());
    }

    default public Supplier<String> webapp() {
        return () -> this.property().apply("server.webapp", "/");
    }

    default public Supplier<String> baseURL() {
        return () -> this.protocol().get() + "://" + this.ip().get() + ":" + this.port().get();
    }

    default public Supplier<String> url() {
        return () -> (String)Case.match((Case.DefaultCase)Case.matchCase(() -> Result.success((Object)("/" + this.webapp().get() + "/"))), (Case[])new Case[]{Case.matchCase(() -> this.webapp().get().equals(""), () -> Result.success((Object)"/")), Case.matchCase(() -> this.webapp().get().endsWith("/") && this.webapp().get().startsWith("/"), () -> Result.success((Object)this.webapp().get())), Case.matchCase(() -> this.webapp().get().endsWith("/") && !this.webapp().get().startsWith("/"), () -> Result.success((Object)("/" + this.webapp().get()))), Case.matchCase(() -> this.webapp().get().equals("/"), () -> Result.success((Object)"/"))}).map(e -> this.baseURL().get() + e).get();
    }

    default public void destroy() {
        ((CheckedExecutor)() -> ((WebDriver)this.getDriver()).quit()).apply(null).ifPresentOrElse(ok -> this.logger().info("webdriver quit -> OK"), failed -> this.logger().warning("webdriver quit failed -> " + failed));
        ((CheckedExecutor)() -> ((WebDriver)this.getDriver()).close()).apply(null).ifPresentOrElse(ok -> this.logger().info("webdriver close -> OK"), failed -> this.logger().warning("webdriver close failed -> " + failed));
    }

    default public void screenshot() {
        WebDriverFunctions.takeScreenShot().accept(this.getDriver());
    }
}

