/*
 * Decompiled with CFR 0.152.
 */
package xxx.com.github.webdriverextensions.internal;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import xxx.com.github.webdriverextensions.WebDriverExtensionFieldDecorator;
import xxx.com.github.webdriverextensions.WebPage;
import xxx.com.github.webdriverextensions.WebRepository;
import xxx.com.github.webdriverextensions.WebSite;
import xxx.com.github.webdriverextensions.internal.WebDriverExtensionException;
import xxx.com.github.webdriverextensions.internal.utils.StringUtils;

public class ObjectPool {
    private final WebDriver driver;
    private final HashMap<Class<?>, WebSite> siteObjects = new HashMap();
    private final HashMap<ClassGeneric, WebPage> pageObjects = new HashMap();
    private final HashMap<ClassGeneric, WebRepository> repositoryObjects = new HashMap();

    public ObjectPool(WebDriver driver) {
        this.driver = driver;
    }

    public WebSite getSiteObject(Field field, WebDriverExtensionFieldDecorator decorator) {
        WebSite siteObject = this.siteObjects.get(field.getType());
        if (siteObject == null) {
            siteObject = this.createSiteObject(field);
            this.siteObjects.put(field.getType(), siteObject);
            siteObject.initElements((FieldDecorator)decorator);
        }
        return siteObject;
    }

    public WebPage getPageObject(Field field, WebDriverExtensionFieldDecorator decorator) {
        WebPage pageObject;
        ClassGeneric key = new ClassGeneric();
        key.clazz = field.getType();
        if (field.getGenericType() instanceof ParameterizedType) {
            key.generics = (ParameterizedType)field.getGenericType();
        }
        if ((pageObject = this.pageObjects.get(key)) == null) {
            pageObject = this.createPageObject(field);
            this.pageObjects.put(key, pageObject);
            if (field.getGenericType() instanceof ParameterizedType) {
                decorator.setGenericTypeArguments((ParameterizedType)field.getGenericType());
            }
            pageObject.initElements((FieldDecorator)decorator);
        }
        return pageObject;
    }

    public WebRepository getRepositoryObject(Field field, WebDriverExtensionFieldDecorator decorator) {
        WebRepository repositoryObject;
        ClassGeneric key = new ClassGeneric();
        key.clazz = field.getType();
        if (field.getGenericType() instanceof ParameterizedType) {
            key.generics = (ParameterizedType)field.getGenericType();
        }
        if ((repositoryObject = this.repositoryObjects.get(key)) == null) {
            repositoryObject = this.createRepositoryObject(field);
            this.repositoryObjects.put(key, repositoryObject);
            if (field.getGenericType() instanceof ParameterizedType) {
                decorator.setGenericTypeArguments((ParameterizedType)field.getGenericType());
            }
            repositoryObject.initElements((FieldDecorator)decorator);
        }
        return repositoryObject;
    }

    private WebSite createSiteObject(Field field) {
        WebSite siteObject;
        try {
            siteObject = (WebSite)field.getType().newInstance();
        }
        catch (InstantiationException ex) {
            if (ex.getCause() instanceof NoSuchMethodException) {
                throw new WebDriverExtensionException("Failed to instantiate WebSite class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since no args constructor is missing. Remove any other constructor or implement a no args constructor.", ex);
            }
            throw new WebDriverExtensionException("Failed to instantiate WebSite class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since class is abstract. Remove the abstract modifier and implement the abstract methods.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new WebDriverExtensionException("Failed to instantiate WebSite class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since constructor is not accessable. Make the constructor public.", ex);
        }
        return siteObject;
    }

    private WebPage createPageObject(Field field) {
        WebPage pageObject;
        try {
            pageObject = (WebPage)field.getType().newInstance();
        }
        catch (InstantiationException ex) {
            if (ex.getCause() instanceof NoSuchMethodException) {
                throw new WebDriverExtensionException("Failed to instantiate WebPage class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since no args constructor is missing. Remove any other constructor or implement a no args constructor.", ex);
            }
            throw new WebDriverExtensionException("Failed to instantiate WebPage class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since class is abstract. Remove the abstract modifier and implement the abstract methods.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new WebDriverExtensionException("Failed to instantiate WebPage class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since constructor is not accessable. Make the constructor public.", ex);
        }
        return pageObject;
    }

    private WebRepository createRepositoryObject(Field field) {
        WebRepository repositoryObject;
        try {
            repositoryObject = (WebRepository)field.getType().newInstance();
        }
        catch (InstantiationException ex) {
            if (ex.getCause() instanceof NoSuchMethodException) {
                throw new WebDriverExtensionException("Failed to instantiate WebRepository class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since no args constructor is missing. Remove any other constructor or implement a no args constructor.", ex);
            }
            throw new WebDriverExtensionException("Failed to instantiate WebRepository class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since class is abstract. Remove the abstract modifier and implement the abstract methods.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new WebDriverExtensionException("Failed to instantiate WebRepository class " + StringUtils.quote(field.getType().getSimpleName()) + " for field " + StringUtils.quote(field.getName()) + " since constructor is not accessable. Make the constructor public.", ex);
        }
        return repositoryObject;
    }

    public static class ClassGeneric {
        Class<?> clazz;
        ParameterizedType generics;

        public int hashCode() {
            return new HashCodeBuilder().append(this.clazz).append((Object)this.generics).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassGeneric) {
                ClassGeneric other = (ClassGeneric)obj;
                return new EqualsBuilder().append(this.clazz, other.clazz).append((Object)this.generics, (Object)other.generics).isEquals();
            }
            return false;
        }
    }
}

