/*
 * Decompiled with CFR 0.152.
 */
package xxx.com.github.webdriverextensions.internal;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import xxx.com.github.webdriverextensions.WebComponent;
import xxx.com.github.webdriverextensions.WebDriverExtensionFieldDecorator;
import xxx.com.github.webdriverextensions.internal.WebComponentFactory;
import xxx.com.github.webdriverextensions.internal.WebDriverExtensionException;

public class WebComponentList<T extends WebComponent>
implements List<T> {
    private Class<T> webComponentClass;
    private List<WebElement> wrappedWebElements;
    private List<T> webComponents;
    private WebComponentFactory webComponentFactory;
    private WebDriver driver;
    private ParameterizedType genericTypeArguments;

    public WebComponentList(Class<T> webComponentClass, List<WebElement> webElements, WebComponentFactory webComponentFactory, WebDriver driver) {
        this.webComponentClass = webComponentClass;
        this.wrappedWebElements = webElements;
        this.webComponentFactory = webComponentFactory;
        this.driver = driver;
    }

    public WebComponentList(Class<T> webComponentClass, List<WebElement> webElements, WebComponentFactory webComponentFactory, WebDriver driver, ParameterizedType genericTypeArguments) {
        this.webComponentClass = webComponentClass;
        this.wrappedWebElements = webElements;
        this.webComponentFactory = webComponentFactory;
        this.driver = driver;
        this.genericTypeArguments = genericTypeArguments;
    }

    public void createWebComponents() {
        this.webComponents = new ArrayList<T>();
        for (WebElement webElement : this.wrappedWebElements) {
            try {
                T webComponent = this.webComponentFactory.create(this.webComponentClass, webElement, this.driver);
                PageFactory.initElements((FieldDecorator)new WebDriverExtensionFieldDecorator((SearchContext)webElement, this.driver, this.genericTypeArguments), webComponent);
                this.webComponents.add(webComponent);
            }
            catch (Exception e) {
                throw new WebDriverExtensionException(e);
            }
        }
    }

    @Override
    public int size() {
        this.createWebComponents();
        return this.webComponents.size();
    }

    @Override
    public boolean isEmpty() {
        this.createWebComponents();
        return this.webComponents.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.createWebComponents();
        return this.webComponents.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        this.createWebComponents();
        return this.webComponents.iterator();
    }

    @Override
    public Object[] toArray() {
        this.createWebComponents();
        return this.webComponents.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        this.createWebComponents();
        return this.webComponents.toArray(ts);
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        this.createWebComponents();
        return this.webComponents.containsAll(clctn);
    }

    @Override
    public boolean addAll(Collection<? extends T> clctn) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> clctn) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public T get(int i) {
        this.createWebComponents();
        return (T)((WebComponent)this.webComponents.get(i));
    }

    @Override
    public T set(int i, T e) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public void add(int i, T e) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("This collection is imnmutable and therefore this method cannot be called.");
    }

    @Override
    public int indexOf(Object o) {
        this.createWebComponents();
        return this.webComponents.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.createWebComponents();
        return this.webComponents.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.createWebComponents();
        return this.webComponents.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        this.createWebComponents();
        return this.webComponents.listIterator();
    }

    @Override
    public List<T> subList(int i, int i1) {
        this.createWebComponents();
        return this.webComponents.subList(i, i1);
    }
}

