/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.ffindex;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rcsb.ffindex.AppendableFileBundle;
import org.rcsb.ffindex.ReadableFileBundle;
import org.rcsb.ffindex.WritableFileBundle;
import org.rcsb.ffindex.impl.ReadOnlyFileBundle;
import org.rcsb.ffindex.impl.ReadWriteFileBundle;
import org.rcsb.ffindex.impl.WriteOnlyFileBundle;

public class FileBundleIO {
    private FileBundleIO() {
    }

    public static ModeStep openBundle(Path dataPath, Path indexPath) {
        return new ModeStep(dataPath, indexPath);
    }

    public static void sortIndexFile(Path indexPath) throws IOException {
        byte[] bytes;
        try (Stream<String> lines = Files.lines(indexPath);){
            bytes = lines.sorted(Comparator.comparing(l -> l.split("\t")[0])).collect(Collectors.joining("\n", "", "\n")).getBytes(StandardCharsets.UTF_8);
        }
        Files.write(indexPath, bytes, new OpenOption[0]);
    }

    public static class ModeStep {
        private final Path dataPath;
        private final Path indexPath;

        private ModeStep(Path dataPath, Path indexPath) {
            this.dataPath = dataPath;
            this.indexPath = indexPath;
        }

        public ReadableFileBundle inReadOnlyMode() throws IOException {
            return new ReadOnlyFileBundle(this.dataPath, this.indexPath);
        }

        public WritableFileBundle inWriteOnlyMode() throws IOException {
            ModeStep.createFiles(false, this.dataPath, this.indexPath);
            return new WriteOnlyFileBundle(this.dataPath, this.indexPath);
        }

        public AppendableFileBundle inReadWriteMode() throws IOException {
            ModeStep.createFiles(true, this.dataPath, this.indexPath);
            return new ReadWriteFileBundle(this.dataPath, this.indexPath);
        }

        private static void createFiles(boolean canExist, Path ... paths) throws IOException {
            for (Path p : paths) {
                if (Files.exists(p, new LinkOption[0]) && canExist) continue;
                Files.createFile(p, new FileAttribute[0]);
            }
        }
    }
}

