/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.ffindex.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.rcsb.ffindex.Entries;

public class ImmutableEntries
implements Entries {
    private final Map<String, Integer> filenames;
    private final long[] offsets;
    private final int[] lengths;

    private ImmutableEntries(Map<String, Integer> filenames, long[] offsets, int[] lengths) {
        this.filenames = filenames;
        this.offsets = offsets;
        this.lengths = lengths;
    }

    public static ImmutableEntries of(Path indexPath) throws IOException {
        List<String> lines = Files.readAllLines(indexPath);
        int lineCount = lines.size();
        HashMap<String, Integer> filenames = new HashMap<String, Integer>();
        long[] offsets = new long[lineCount];
        int[] lengths = new int[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            String[] split = lines.get(i).split("\t");
            filenames.put(split[0], i);
            offsets[i] = Long.parseLong(split[1]);
            lengths[i] = Integer.parseInt(split[2]);
        }
        return new ImmutableEntries(filenames, offsets, lengths);
    }

    @Override
    public int getIndex(String filename) {
        return this.filenames.getOrDefault(filename, -1);
    }

    @Override
    public long getOffset(int index) {
        return this.offsets[index];
    }

    @Override
    public int getLength(int index) {
        return this.lengths[index];
    }

    @Override
    public Stream<String> filenames() {
        return this.filenames.keySet().stream();
    }

    @Override
    public int size() {
        return this.filenames.size();
    }
}

