/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.ffindex.impl;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.rcsb.ffindex.Entries;

public class MutableEntries
implements Entries {
    private final Map<String, Integer> indices;
    private final List<Long> offsets;
    private final List<Integer> lengths;

    private MutableEntries(Map<String, Integer> indices, List<Long> offsets, List<Integer> lengths) {
        this.indices = indices;
        this.offsets = offsets;
        this.lengths = lengths;
    }

    public static MutableEntries of(Path indexPath) throws IOException {
        List<String> lines = Files.readAllLines(indexPath);
        int lineCount = lines.size();
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (int i = 0; i < lineCount; ++i) {
            String[] split = lines.get(i).split("\t");
            indices.put(split[0], i);
            offsets.add(Long.parseLong(split[1]));
            lengths.add(Integer.parseInt(split[2]));
        }
        return new MutableEntries(indices, offsets, lengths);
    }

    @Override
    public int getIndex(String filename) {
        return this.indices.getOrDefault(filename, -1);
    }

    @Override
    public long getOffset(int index) {
        return this.offsets.get(index);
    }

    @Override
    public int getLength(int index) {
        return this.lengths.get(index);
    }

    @Override
    public Stream<String> filenames() {
        return this.indices.keySet().stream();
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    public void addFile(String filename, long offset, int length) throws IOException {
        if (this.indices.containsKey(filename)) {
            throw new FileAlreadyExistsException("File " + filename + " is already registered in bundle");
        }
        this.indices.put(filename, this.indices.size());
        this.offsets.add(offset);
        this.lengths.add(length);
    }
}

