/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.ffindex.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.rcsb.ffindex.ReadableFileBundle;
import org.rcsb.ffindex.impl.AbstractFileBundle;
import org.rcsb.ffindex.impl.ImmutableEntries;

public class ReadOnlyFileBundle
extends AbstractFileBundle
implements ReadableFileBundle {
    private final ImmutableEntries entries;

    public ReadOnlyFileBundle(Path dataPath, Path indexPath) throws IOException {
        super(dataPath, indexPath, "r");
        this.entries = ImmutableEntries.of(indexPath);
    }

    @Override
    public ByteBuffer readFile(String filename) throws IOException {
        int index = this.entries.getIndex(filename);
        if (index == -1) {
            throw new NoSuchFileException("No file with name '" + filename + "'");
        }
        return this.dataFileChannel.map(FileChannel.MapMode.READ_ONLY, this.entries.getOffset(index), (long)this.entries.getLength(index) - (long)FILE_END_LENGTH);
    }

    @Override
    public boolean containsFile(String filename) {
        return this.entries.getIndex(filename) != -1;
    }

    @Override
    public int fileCount() {
        return this.entries.size();
    }

    @Override
    public Stream<String> filenames() {
        return this.entries.filenames();
    }

    @Override
    public void close() throws IOException {
        this.dataFileChannel.close();
        this.dataFile.close();
    }
}

