/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.ffindex.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.rcsb.ffindex.AppendableFileBundle;
import org.rcsb.ffindex.impl.AbstractFileBundle;
import org.rcsb.ffindex.impl.MutableEntries;
import org.rcsb.ffindex.impl.WriteLock;

public class ReadWriteFileBundle
extends AbstractFileBundle
implements AppendableFileBundle {
    private final WriteLock writeLock = new WriteLock(){};
    private final FileChannel indexFileChannel;
    private final MutableEntries entries;
    private long offset;

    public ReadWriteFileBundle(Path dataPath, Path indexPath) throws IOException {
        super(dataPath, indexPath, "rw");
        this.indexFileChannel = new FileOutputStream(indexPath.toFile(), true).getChannel();
        this.entries = MutableEntries.of(indexPath);
        this.offset = 0L;
        if (this.entries.size() > 0) {
            int index = 0;
            long largestOffset = -1L;
            for (int i = 0; i < this.entries.size(); ++i) {
                long o = this.entries.getOffset(i);
                if (o <= largestOffset) continue;
                largestOffset = o;
                index = i;
            }
            this.offset = largestOffset + (long)this.entries.getLength(index);
            this.dataFileChannel.position(this.offset);
        }
    }

    @Override
    public ByteBuffer readFile(String filename) throws IOException {
        int index = this.entries.getIndex(filename);
        if (index == -1) {
            throw new NoSuchFileException("No file with name '" + filename + "'");
        }
        return this.dataFileChannel.map(FileChannel.MapMode.READ_ONLY, this.entries.getOffset(index), (long)this.entries.getLength(index) - (long)FILE_END_LENGTH);
    }

    @Override
    public boolean containsFile(String filename) {
        return this.entries.getIndex(filename) != -1;
    }

    @Override
    public int fileCount() {
        return this.entries.size();
    }

    @Override
    public Stream<String> filenames() {
        return this.entries.filenames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(String filename, ByteBuffer byteBuffer) throws IOException {
        if (this.containsFile(filename)) {
            throw new IllegalStateException("File '" + filename + "' already exists - write to a new file if you want to update existing content");
        }
        int length = byteBuffer.limit() + FILE_END_LENGTH;
        WriteLock writeLock = this.writeLock;
        synchronized (writeLock) {
            this.writeIndexEntry(filename, length);
            this.writeData(byteBuffer);
        }
    }

    private void writeIndexEntry(String filename, int length) throws IOException {
        this.entries.addFile(filename, this.offset, length);
        String line = filename + "\t" + this.offset + "\t" + length + "\n";
        ByteBuffer out = ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8));
        this.indexFileChannel.write(out);
    }

    private void writeData(ByteBuffer byteBuffer) throws IOException {
        this.offset += (long)this.dataFileChannel.write(byteBuffer);
        FILE_END_BUFFER.rewind();
        this.offset += (long)this.dataFileChannel.write(FILE_END_BUFFER);
    }

    @Override
    public void close() throws IOException {
        this.indexFileChannel.close();
        this.dataFileChannel.close();
        this.dataFile.close();
    }
}

