/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.ffindex.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.rcsb.ffindex.WritableFileBundle;
import org.rcsb.ffindex.impl.AbstractFileBundle;
import org.rcsb.ffindex.impl.WriteLock;

public class WriteOnlyFileBundle
extends AbstractFileBundle
implements WritableFileBundle {
    private final WriteLock writeLock = new WriteLock(){};
    private final FileChannel indexFileChannel;
    private long offset;

    public WriteOnlyFileBundle(Path dataPath, Path indexPath) throws FileNotFoundException {
        super(dataPath, indexPath, "rw");
        this.indexFileChannel = new FileOutputStream(indexPath.toFile(), true).getChannel();
        this.offset = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(String filename, ByteBuffer byteBuffer) throws IOException {
        int length = byteBuffer.limit() + FILE_END_LENGTH;
        WriteLock writeLock = this.writeLock;
        synchronized (writeLock) {
            this.writeIndexEntry(filename, length);
            this.writeData(byteBuffer);
        }
    }

    private void writeIndexEntry(String filename, int length) throws IOException {
        String line = filename + "\t" + this.offset + "\t" + length + "\n";
        ByteBuffer out = ByteBuffer.wrap(line.getBytes(StandardCharsets.UTF_8));
        this.indexFileChannel.write(out);
    }

    private void writeData(ByteBuffer byteBuffer) throws IOException {
        this.offset += (long)this.dataFileChannel.write(byteBuffer);
        FILE_END_BUFFER.rewind();
        this.offset += (long)this.dataFileChannel.write(FILE_END_BUFFER);
    }

    @Override
    public void close() throws IOException {
        this.indexFileChannel.close();
        this.dataFileChannel.close();
        this.dataFile.close();
    }
}

