/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.align;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.rcsb.strucmotif.align.AlignmentService;
import org.rcsb.strucmotif.domain.Pair;
import org.rcsb.strucmotif.domain.Transformation;
import org.rcsb.strucmotif.domain.align.AlignmentResult;
import org.rcsb.strucmotif.domain.align.AlignmentResultImpl;
import org.rcsb.strucmotif.domain.align.AtomCorrespondence;
import org.rcsb.strucmotif.domain.align.AtomPairingScheme;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.math.Algebra;
import org.springframework.stereotype.Service;

@Service
public class QuaternionAlignmentService
implements AlignmentService {
    @Override
    public AlignmentResult align(List<Map<LabelAtomId, float[]>> reference, List<Map<LabelAtomId, float[]>> candidate, AtomPairingScheme atomPairingScheme) {
        if (reference.size() != candidate.size()) {
            throw new IllegalArgumentException("cannot align containers of unequal size - " + reference.size() + " vs " + candidate.size() + " : " + reference + " vs " + candidate);
        }
        Objects.requireNonNull(atomPairingScheme, "alignment scheme cannot be null");
        AtomCorrespondence atomCorrespondence = new AtomCorrespondence(reference, candidate, atomPairingScheme);
        return this.align(atomCorrespondence);
    }

    private AlignmentResult align(AtomCorrespondence atomCorrespondence) {
        List<float[]> referencePoints = atomCorrespondence.getCenteredReferenceVectors();
        float[] referenceCentroid = atomCorrespondence.getReferenceCentroid();
        List<float[]> candidatePoints = atomCorrespondence.getCenteredCandidateVectors();
        float[] candidateCentroid = atomCorrespondence.getCandidateCentroid();
        Pair<Transformation, Float> alignment = QuaternionAlignmentService.align(referencePoints, referenceCentroid, candidatePoints, candidateCentroid);
        return new AlignmentResultImpl(alignment.getFirst(), alignment.getSecond().floatValue());
    }

    public static Pair<Transformation, Float> align(List<float[]> referencePoints, float[] referenceCentroid, List<float[]> candidatePoints, float[] candidateCentroid) {
        double oldg;
        double x2;
        double b;
        double a;
        double delta;
        float[][] rot = new float[3][3];
        double g1 = 0.0;
        double g2 = 0.0;
        double[] matA = new double[9];
        for (int i = 0; i < referencePoints.size(); ++i) {
            float[] r = referencePoints.get(i);
            float[] c = candidatePoints.get(i);
            double x1 = r[0];
            double y1 = r[1];
            double z1 = r[2];
            g1 += x1 * x1 + y1 * y1 + z1 * z1;
            double x22 = c[0];
            double y2 = c[1];
            double z2 = c[2];
            g2 += x22 * x22 + y2 * y2 + z2 * z2;
            matA[0] = matA[0] + x1 * x22;
            matA[1] = matA[1] + x1 * y2;
            matA[2] = matA[2] + x1 * z2;
            matA[3] = matA[3] + y1 * x22;
            matA[4] = matA[4] + y1 * y2;
            matA[5] = matA[5] + y1 * z2;
            matA[6] = matA[6] + z1 * x22;
            matA[7] = matA[7] + z1 * y2;
            matA[8] = matA[8] + z1 * z2;
        }
        double e0 = (g1 + g2) * 0.5;
        double[] c = new double[4];
        double evecprec = 1.0E-6;
        double evalprec = 1.0E-11;
        double sxx = matA[0];
        double sxy = matA[1];
        double sxz = matA[2];
        double syx = matA[3];
        double syy = matA[4];
        double syz = matA[5];
        double szx = matA[6];
        double szy = matA[7];
        double szz = matA[8];
        double sxx2 = sxx * sxx;
        double syy2 = syy * syy;
        double szz2 = szz * szz;
        double sxy2 = sxy * sxy;
        double syz2 = syz * syz;
        double sxz2 = sxz * sxz;
        double syx2 = syx * syx;
        double szy2 = szy * szy;
        double szx2 = szx * szx;
        double syzszymsyyszz2 = 2.0 * (syz * szy - syy * szz);
        double sxx2syy2szz2syz2szy2 = syy2 + szz2 - sxx2 + syz2 + szy2;
        c[2] = -2.0 * (sxx2 + syy2 + szz2 + sxy2 + syx2 + sxz2 + szx2 + syz2 + szy2);
        c[1] = 8.0 * (sxx * syz * szy + syy * szx * sxz + szz * sxy * syx - sxx * syy * szz - syz * szx * sxy - szy * syx * sxz);
        double sxzpszx = sxz + szx;
        double syzpszy = syz + szy;
        double sxypsyx = sxy + syx;
        double syzmszy = syz - szy;
        double sxzmszx = sxz - szx;
        double sxymsyx = sxy - syx;
        double sxxpsyy = sxx + syy;
        double sxxmsyy = sxx - syy;
        double sxy2sxz2syx2szx2 = sxy2 + sxz2 - syx2 - szx2;
        c[0] = sxy2sxz2syx2szx2 * sxy2sxz2syx2szx2 + (sxx2syy2szz2syz2szy2 + syzszymsyyszz2) * (sxx2syy2szz2syz2szy2 - syzszymsyyszz2) + (-sxzpszx * syzmszy + sxymsyx * (sxxmsyy - szz)) * (-sxzmszx * syzpszy + sxymsyx * (sxxmsyy + szz)) + (-sxzpszx * syzpszy - sxypsyx * (sxxpsyy - szz)) * (-sxzmszx * syzmszy - sxypsyx * (sxxpsyy + szz)) + (sxypsyx * syzpszy + sxzpszx * (sxxmsyy + szz)) * (-sxymsyx * syzmszy + sxzpszx * (sxxpsyy + szz)) + (sxypsyx * syzmszy + sxzmszx * (sxxmsyy - szz)) * (-sxymsyx * syzpszy + sxzmszx * (sxxpsyy - szz));
        double mxEigenV = e0;
        for (int i = 0; i < 50 && !(Math.abs((mxEigenV -= (delta = ((a = (b = ((x2 = mxEigenV * mxEigenV) + c[2]) * mxEigenV) + c[1]) * mxEigenV + c[0]) / (2.0 * x2 * mxEigenV + b + a))) - (oldg = mxEigenV)) < Math.abs(evalprec * mxEigenV)); ++i) {
        }
        double rms = Math.sqrt(Math.abs(2.0 * (e0 - mxEigenV) / (double)referencePoints.size()));
        double a11 = sxxpsyy + szz - mxEigenV;
        double a12 = syzmszy;
        double a22 = sxxmsyy - szz - mxEigenV;
        double a33 = syy - sxx - szz - mxEigenV;
        double a44 = szz - sxxpsyy - mxEigenV;
        double a34 = syzpszy;
        double a43 = a34;
        double a33444334 = a33 * a44 - a43 * a34;
        double a23 = sxypsyx;
        double a32 = a23;
        double a24 = sxzpszx;
        double a42 = a24;
        double a32444234 = a32 * a44 - a42 * a34;
        double a32434233 = a32 * a43 - a42 * a33;
        double q1 = a22 * a33444334 - a23 * a32444234 + a24 * a32434233;
        double a21 = syzmszy;
        double a13 = -sxzmszx;
        double a31 = a13;
        double a14 = sxymsyx;
        double a41 = a14;
        double a31444134 = a31 * a44 - a41 * a34;
        double a31434133 = a31 * a43 - a41 * a33;
        double q2 = -a21 * a33444334 + a23 * a31444134 - a24 * a31434133;
        double a31424132 = a31 * a42 - a41 * a32;
        double q3 = a21 * a32444234 - a22 * a31444134 + a24 * a31424132;
        double q4 = -a21 * a32434233 + a22 * a31434133 - a23 * a31424132;
        double qsqr = q1 * q1 + q2 * q2 + q3 * q3 + q4 * q4;
        if (qsqr < evecprec) {
            double a11221221;
            double a11231321;
            double a11241421;
            double a12231322;
            double a12241422;
            double a13241423;
            q1 = a12 * a33444334 - a13 * a32444234 + a14 * a32434233;
            q2 = -a11 * a33444334 + a13 * a31444134 - a14 * a31434133;
            q3 = a11 * a32444234 - a12 * a31444134 + a14 * a31424132;
            q4 = -a11 * a32434233 + a12 * a31434133 - a13 * a31424132;
            qsqr = q1 * q1 + q2 * q2 + q3 * q3 + q4 * q4;
            if (qsqr < evecprec && (qsqr = (q1 = a42 * (a13241423 = a13 * a24 - a14 * a23) - a43 * (a12241422 = a12 * a24 - a14 * a22) + a44 * (a12231322 = a12 * a23 - a13 * a22)) * q1 + (q2 = -a41 * a13241423 + a43 * (a11241421 = a11 * a24 - a14 * a21) - a44 * (a11231321 = a11 * a23 - a13 * a21)) * q2 + (q3 = a41 * a12241422 - a42 * a11241421 + a44 * (a11221221 = a11 * a22 - a12 * a21)) * q3 + (q4 = -a41 * a12231322 + a42 * a11231321 - a43 * a11221221) * q4) < evecprec && (qsqr = (q1 = a32 * a13241423 - a33 * a12241422 + a34 * a12231322) * q1 + (q2 = -a31 * a13241423 + a33 * a11241421 - a34 * a11231321) * q2 + (q3 = a31 * a12241422 - a32 * a11241421 + a34 * a11221221) * q3 + (q4 = -a31 * a12231322 + a32 * a11231321 - a33 * a11221221) * q4) < evecprec) {
                rot = Transformation.IDENTITY_MATRIX_3D;
            }
        } else {
            double normq = Math.sqrt(qsqr);
            double a2 = (q1 /= normq) * q1;
            x2 = (q2 /= normq) * q2;
            double y2 = (q3 /= normq) * q3;
            double z2 = (q4 /= normq) * q4;
            double xy = q2 * q3;
            double az = q1 * q4;
            double zx = q4 * q2;
            double ay = q1 * q3;
            double yz = q3 * q4;
            double ax = q1 * q2;
            rot[0][0] = (float)(a2 + x2 - y2 - z2);
            rot[0][1] = (float)(2.0 * (xy + az));
            rot[0][2] = (float)(2.0 * (zx - ay));
            rot[1][0] = (float)(2.0 * (xy - az));
            rot[1][1] = (float)(a2 - x2 + y2 - z2);
            rot[1][2] = (float)(2.0 * (yz + ax));
            rot[2][0] = (float)(2.0 * (zx + ay));
            rot[2][1] = (float)(2.0 * (yz - ax));
            rot[2][2] = (float)(a2 - x2 - y2 + z2);
        }
        Algebra.multiply3d(candidateCentroid, Algebra.transpose3d(rot), candidateCentroid);
        float[] translation = new float[3];
        Algebra.subtract3d(translation, referenceCentroid, candidateCentroid);
        float[][] transformation = Algebra.composeTransformationMatrix(rot, translation);
        return new Pair<Transformation, Float>(Transformation.of(transformation), Float.valueOf((float)rms));
    }
}

