/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.config;

import java.util.function.BiPredicate;

public enum ResidueQualityStrategy implements BiPredicate<Double, Double>
{
    NONE((v, c) -> true),
    BFACTOR_ABOVE_CUTOFF((v, c) -> v > c),
    BFACTOR_BELOW_CUTOFF((v, c) -> v < c),
    QA_METRIC_LOCAL_ABOVE_CUTOFF((v, c) -> v > c),
    QA_METRIC_LOCAL_BELOW_CUTOFF((v, c) -> v < c);

    private final BiPredicate<Double, Double> predicate;

    private ResidueQualityStrategy(BiPredicate<Double, Double> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(Double value, Double cutoff) {
        return this.predicate.test(value, cutoff);
    }
}

