/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.config;

import org.rcsb.strucmotif.config.InMemoryStrategy;
import org.rcsb.strucmotif.config.InvertedIndexBackend;
import org.rcsb.strucmotif.config.ModifiedResidueStrategy;
import org.rcsb.strucmotif.config.ResidueQualityStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="strucmotif")
public class StrucmotifConfig {
    private float distanceCutoff = 15.0f;
    private String rootPath = "/opt/data/";
    private String dataSource = "/opt/pdb/{middle}/{id}.bcif.gz";
    private int numberThreads = Runtime.getRuntime().availableProcessors();
    private int maxResults = 50000;
    private int decimalPlacesScore = 2;
    private int decimalPlacesMatrix = 3;
    private int updateChunkSize = 1600;
    private int loadingChunkSize = 12800;
    private int maxMotifSize = 10;
    private String cifFetchUrl = "https://models.rcsb.org/{id}.bcif";
    private int renumberedCoordinatePrecision = 1;
    private boolean renumberedGzip = true;
    private boolean invertedIndexGzip = false;
    private int downloadTries = 5;
    private InMemoryStrategy inMemoryStrategy = InMemoryStrategy.OFF;
    private boolean undefinedAssemblies = true;
    private float residueQualityCutoff = 70.0f;
    private ResidueQualityStrategy residueQualityStrategy = ResidueQualityStrategy.QA_METRIC_LOCAL_ABOVE_CUTOFF;
    private InvertedIndexBackend invertedIndexBackend = InvertedIndexBackend.COLFER;
    private String undefinedAssemblyIdentifier = "0";
    private ModifiedResidueStrategy modifiedResidueStrategy = ModifiedResidueStrategy.INTERNAL;
    private int commitInterval = 16;
    private String rcsbEntryHoldingsUrl = "https://data.rcsb.org/rest/v1/holdings/current/entry_ids";
    private String ccdUrl = "https://ftp.wwpdb.org/pub/pdb/data/monomers/components.cif.gz";
    private boolean supportDAminoAcids = true;
    public static final String STATE_KNOWN_LIST = "known.list";
    public static final String STATE_DIRTY_LIST = "dirty.list";
    public static final String RENUMBERED_DIRECTORY = "renumbered";
    public static final String INDEX_DIRECTORY = "index";

    public float getDistanceCutoff() {
        return this.distanceCutoff;
    }

    public void setDistanceCutoff(float distanceCutoff) {
        this.distanceCutoff = distanceCutoff;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public int getNumberThreads() {
        return this.numberThreads;
    }

    public void setNumberThreads(int numberThreads) {
        this.numberThreads = numberThreads;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getDecimalPlacesScore() {
        return this.decimalPlacesScore;
    }

    public void setDecimalPlacesScore(int decimalPlacesScore) {
        this.decimalPlacesScore = decimalPlacesScore;
    }

    public int getDecimalPlacesMatrix() {
        return this.decimalPlacesMatrix;
    }

    public void setDecimalPlacesMatrix(int decimalPlacesMatrix) {
        this.decimalPlacesMatrix = decimalPlacesMatrix;
    }

    public int getUpdateChunkSize() {
        return this.updateChunkSize;
    }

    public void setUpdateChunkSize(int updateChunkSize) {
        this.updateChunkSize = updateChunkSize;
    }

    public int getLoadingChunkSize() {
        return this.loadingChunkSize;
    }

    public void setLoadingChunkSize(int loadingChunkSize) {
        this.loadingChunkSize = loadingChunkSize;
    }

    public int getMaxMotifSize() {
        return this.maxMotifSize;
    }

    public void setMaxMotifSize(int maxMotifSize) {
        this.maxMotifSize = maxMotifSize;
    }

    public String getCifFetchUrl() {
        return this.cifFetchUrl;
    }

    public void setCifFetchUrl(String cifFetchUrl) {
        this.cifFetchUrl = cifFetchUrl;
    }

    public float getSquaredDistanceCutoff() {
        return this.distanceCutoff * this.distanceCutoff;
    }

    public int getRenumberedCoordinatePrecision() {
        return this.renumberedCoordinatePrecision;
    }

    public void setRenumberedCoordinatePrecision(int renumberedCoordinatePrecision) {
        this.renumberedCoordinatePrecision = renumberedCoordinatePrecision;
    }

    public boolean isRenumberedGzip() {
        return this.renumberedGzip;
    }

    public void setRenumberedGzip(boolean renumberedGzip) {
        this.renumberedGzip = renumberedGzip;
    }

    public boolean isInvertedIndexGzip() {
        return this.invertedIndexGzip;
    }

    public void setInvertedIndexGzip(boolean invertedIndexGzip) {
        this.invertedIndexGzip = invertedIndexGzip;
    }

    public int getDownloadTries() {
        return this.downloadTries;
    }

    public void setDownloadTries(int downloadTries) {
        this.downloadTries = downloadTries;
    }

    public InMemoryStrategy getInMemoryStrategy() {
        return this.inMemoryStrategy;
    }

    public void setInMemoryStrategy(InMemoryStrategy inMemoryStrategy) {
        this.inMemoryStrategy = inMemoryStrategy;
    }

    public boolean isUndefinedAssemblies() {
        return this.undefinedAssemblies;
    }

    public void setUndefinedAssemblies(boolean undefinedAssemblies) {
        this.undefinedAssemblies = undefinedAssemblies;
    }

    public float getResidueQualityCutoff() {
        return this.residueQualityCutoff;
    }

    public void setResidueQualityCutoff(float residueQualityCutoff) {
        this.residueQualityCutoff = residueQualityCutoff;
    }

    public ResidueQualityStrategy getResidueQualityStrategy() {
        return this.residueQualityStrategy;
    }

    public void setResidueQualityStrategy(ResidueQualityStrategy residueQualityStrategy) {
        this.residueQualityStrategy = residueQualityStrategy;
    }

    public InvertedIndexBackend getInvertedIndexBackend() {
        return this.invertedIndexBackend;
    }

    public void setInvertedIndexBackend(InvertedIndexBackend invertedIndexBackend) {
        this.invertedIndexBackend = invertedIndexBackend;
    }

    public String getUndefinedAssemblyIdentifier() {
        return this.undefinedAssemblyIdentifier;
    }

    public void setUndefinedAssemblyIdentifier(String undefinedAssemblyIdentifier) {
        this.undefinedAssemblyIdentifier = undefinedAssemblyIdentifier;
    }

    public ModifiedResidueStrategy getModifiedResidueStrategy() {
        return this.modifiedResidueStrategy;
    }

    public void setModifiedResidueStrategy(ModifiedResidueStrategy modifiedResidueStrategy) {
        this.modifiedResidueStrategy = modifiedResidueStrategy;
    }

    public int getCommitInterval() {
        return this.commitInterval;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public String getRcsbEntryHoldingsUrl() {
        return this.rcsbEntryHoldingsUrl;
    }

    public void setRcsbEntryHoldingsUrl(String rcsbEntryHoldingsUrl) {
        this.rcsbEntryHoldingsUrl = rcsbEntryHoldingsUrl;
    }

    public String getCcdUrl() {
        return this.ccdUrl;
    }

    public void setCcdUrl(String ccdUrl) {
        this.ccdUrl = ccdUrl;
    }

    public boolean isSupportDAminoAcids() {
        return this.supportDAminoAcids;
    }

    public void setSupportDAminoAcids(boolean supportDAminoAcids) {
        this.supportDAminoAcids = supportDAminoAcids;
    }
}

