/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.core;

import java.util.List;
import java.util.Map;
import org.rcsb.strucmotif.align.AlignmentService;
import org.rcsb.strucmotif.domain.align.AlignmentResult;
import org.rcsb.strucmotif.domain.align.AtomPairingScheme;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;

public class HitScorer {
    private final List<Map<LabelAtomId, float[]>> queryResidues;
    private final AtomPairingScheme atomPairingScheme;
    private final AlignmentService alignmentService;

    public HitScorer(List<Map<LabelAtomId, float[]>> queryResidues, AtomPairingScheme atomPairingScheme, AlignmentService alignmentService) {
        this.queryResidues = queryResidues;
        this.atomPairingScheme = atomPairingScheme;
        this.alignmentService = alignmentService;
    }

    public AtomPairingScheme getAtomPairingScheme() {
        return this.atomPairingScheme;
    }

    public List<Map<LabelAtomId, float[]>> getQueryResidues() {
        return this.queryResidues;
    }

    public AlignmentResult alignToReference(List<Map<LabelAtomId, float[]>> targetResidues) {
        return this.alignmentService.align(this.queryResidues, targetResidues, this.atomPairingScheme);
    }
}

