/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.core.MotifPruner;
import org.rcsb.strucmotif.domain.motif.ResiduePairOccurrence;
import org.rcsb.strucmotif.domain.structure.IndexSelection;
import org.rcsb.strucmotif.domain.structure.ResidueGraph;
import org.springframework.stereotype.Service;

@Service
public class KruskalMotifPruner
implements MotifPruner {
    @Override
    public List<ResiduePairOccurrence> prune(ResidueGraph residueGraph) {
        List<ResiduePairOccurrence> residuePairOccurrences = residueGraph.residuePairOccurrencesSequential().collect(Collectors.toList());
        if (residueGraph.getNumberOfResidues() < 4) {
            return residuePairOccurrences;
        }
        return this.kruskal(residuePairOccurrences);
    }

    private List<ResiduePairOccurrence> kruskal(List<ResiduePairOccurrence> residuePairOccurrences) {
        ArrayList<Set<IndexSelection>> coveredSelectors = new ArrayList<Set<IndexSelection>>();
        ArrayList<ResiduePairOccurrence> result = new ArrayList<ResiduePairOccurrence>();
        residuePairOccurrences.sort(Comparator.comparingInt(mo -> mo.getResiduePairDescriptor().getBackboneDistance().ordinal()));
        while (!residuePairOccurrences.isEmpty()) {
            ResiduePairOccurrence best = residuePairOccurrences.remove(0);
            IndexSelection id1 = best.getResidueIdentifier().getIndexSelection1();
            IndexSelection id2 = best.getResidueIdentifier().getIndexSelection2();
            Set<IndexSelection> set1 = this.find(coveredSelectors, id1);
            Set<IndexSelection> set2 = this.find(coveredSelectors, id2);
            if (set1 != null && set1.equals(set2)) continue;
            result.add(best);
            HashSet<IndexSelection> updated = new HashSet<IndexSelection>();
            if (set1 != null) {
                coveredSelectors.remove(set1);
                updated.addAll(set1);
            }
            if (set2 != null) {
                coveredSelectors.remove(set2);
                updated.addAll(set2);
            }
            updated.add(id1);
            updated.add(id2);
            coveredSelectors.add(updated);
        }
        return result;
    }

    private Set<IndexSelection> find(List<Set<IndexSelection>> selectors, IndexSelection selector) {
        return selectors.stream().filter(list -> list.contains(selector)).findFirst().orElse(null);
    }
}

