/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.core;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.core.MotifDefinitionRegistry;
import org.rcsb.strucmotif.domain.motif.EnrichedMotifDefinition;
import org.rcsb.strucmotif.domain.motif.MotifDefinition;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.StructureDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MotifDefinitionRegistryImpl
implements MotifDefinitionRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MotifDefinitionRegistryImpl.class);
    private final StructureDataProvider structureDataProvider;
    private final Set<MotifDefinition> motifDefinitions;
    private final AtomicBoolean dirty;
    private Set<EnrichedMotifDefinition> enrichedMotifDefinitions;

    @Autowired
    public MotifDefinitionRegistryImpl(StructureDataProvider structureDataProvider) {
        this.structureDataProvider = structureDataProvider;
        this.motifDefinitions = new HashSet<MotifDefinition>();
        this.dirty = new AtomicBoolean(false);
        this.init();
    }

    private void init() {
        logger.info("Initializing motif definition registry");
        logger.debug("Loading hard-coded definitions");
        try {
            for (Field field : MotifDefinition.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(MotifDefinition.class)) continue;
                this.motifDefinitions.add((MotifDefinition)field.get(MotifDefinition.class));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        logger.debug("Parsing definitions from motifs.json");
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("motifs.json");
        this.parseAndAddMotifDefinitions(inputStream);
        logger.info("{} motifs registered", (Object)this.motifDefinitions.size());
        this.dirty.set(true);
    }

    @Override
    public boolean parseAndAddMotifDefinitions(InputStream inputStream) {
        List motifs = (List)GsonHolder.instance.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), ListTypeHolder.instance);
        return this.addMotifDefinitions(motifs);
    }

    @Override
    public boolean addMotifDefinition(MotifDefinition motifDefinition) {
        boolean changed = this.motifDefinitions.add(motifDefinition);
        if (changed) {
            this.sync(this::defaultMapping);
        }
        return changed;
    }

    @Override
    public boolean addMotifDefinitions(Collection<MotifDefinition> motifDefinitions) {
        boolean changed = this.motifDefinitions.addAll(motifDefinitions);
        if (changed) {
            this.sync(this::defaultMapping);
        }
        return changed;
    }

    @Override
    public boolean removeMotifDefinition(MotifDefinition motifDefinition) {
        boolean changed = this.motifDefinitions.remove(motifDefinition);
        if (changed) {
            this.sync(this::defaultMapping);
        }
        return changed;
    }

    @Override
    public boolean removeMotifDefinitions(Collection<MotifDefinition> motifDefinitions) {
        boolean changed = this.motifDefinitions.removeAll(motifDefinitions);
        if (changed) {
            this.sync(this::defaultMapping);
        }
        return changed;
    }

    @Override
    public boolean removeMotifDefinitions(Predicate<? super MotifDefinition> predicate) {
        boolean changed = this.motifDefinitions.removeIf(predicate);
        if (changed) {
            this.sync(this::defaultMapping);
        }
        return changed;
    }

    @Override
    public Set<MotifDefinition> getMotifDefinitions() {
        return this.motifDefinitions;
    }

    @Override
    public int size() {
        return this.motifDefinitions.size();
    }

    private EnrichedMotifDefinition defaultMapping(MotifDefinition motifDefinition) {
        Structure structure = this.structureDataProvider.readSome(motifDefinition.getStructureIdentifier());
        List<Map<LabelAtomId, float[]>> residues = structure.manifestResidues(motifDefinition.getLabelSelections());
        return new EnrichedMotifDefinition(motifDefinition, structure, residues);
    }

    @Override
    public Set<EnrichedMotifDefinition> getEnrichedMotifDefinitions() {
        if (this.dirty.get()) {
            this.sync(this::defaultMapping);
        }
        return this.enrichedMotifDefinitions;
    }

    @Override
    public Set<EnrichedMotifDefinition> enrichMotifDefinitions(Function<MotifDefinition, EnrichedMotifDefinition> mapper) {
        return this.motifDefinitions.stream().map(mapper).collect(Collectors.toSet());
    }

    @Override
    public Function<MotifDefinition, EnrichedMotifDefinition> getDefaultEnricher() {
        return this::defaultMapping;
    }

    private synchronized void sync(Function<MotifDefinition, EnrichedMotifDefinition> mapper) {
        if (!this.dirty.get()) {
            return;
        }
        long start = System.nanoTime();
        this.enrichedMotifDefinitions = this.enrichMotifDefinitions(mapper);
        logger.info("Synchronized enriched motifs in {} ms", (Object)((double)(System.nanoTime() - start) * 0.001 * 0.001));
        this.dirty.set(false);
    }

    static class GsonHolder {
        static final Gson instance = new Gson();

        GsonHolder() {
        }
    }

    static class ListTypeHolder {
        static final Type instance = new TypeToken<ArrayList<MotifDefinition>>(){}.getType();

        ListTypeHolder() {
        }
    }
}

