/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.core;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rcsb.strucmotif.align.AlignmentService;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.core.HitScorer;
import org.rcsb.strucmotif.core.IllegalQueryDefinitionException;
import org.rcsb.strucmotif.core.StrucmotifRuntime;
import org.rcsb.strucmotif.core.TargetAssembler;
import org.rcsb.strucmotif.core.ThreadPool;
import org.rcsb.strucmotif.domain.MotifSearchContext;
import org.rcsb.strucmotif.domain.StructureSearchContext;
import org.rcsb.strucmotif.domain.motif.EnrichedMotifDefinition;
import org.rcsb.strucmotif.domain.motif.MotifDefinition;
import org.rcsb.strucmotif.domain.query.StructureParameters;
import org.rcsb.strucmotif.domain.query.StructureQuery;
import org.rcsb.strucmotif.domain.result.MotifHit;
import org.rcsb.strucmotif.domain.result.MotifSearchResult;
import org.rcsb.strucmotif.domain.result.StructureHit;
import org.rcsb.strucmotif.domain.result.StructureSearchResult;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.AssemblyInformationProvider;
import org.rcsb.strucmotif.io.StructureDataProvider;
import org.rcsb.strucmotif.io.StructureIndexProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StrucmotifRuntimeImpl
implements StrucmotifRuntime {
    private static final Logger logger = LoggerFactory.getLogger(StrucmotifRuntimeImpl.class);
    private final TargetAssembler targetAssembler;
    private final ThreadPool threadPool;
    private final StrucmotifConfig strucmotifConfig;
    private final AlignmentService alignmentService;
    private final AssemblyInformationProvider assemblyInformationProvider;

    @Autowired
    public StrucmotifRuntimeImpl(TargetAssembler targetAssembler, ThreadPool threadPool, StrucmotifConfig strucmotifConfig, AlignmentService alignmentService, AssemblyInformationProvider assemblyInformationProvider) {
        this.targetAssembler = targetAssembler;
        this.threadPool = threadPool;
        this.strucmotifConfig = strucmotifConfig;
        this.alignmentService = alignmentService;
        this.assemblyInformationProvider = assemblyInformationProvider;
    }

    @Override
    public void performSearch(StructureSearchContext context) {
        try {
            StructureSearchResult result = context.getResult();
            this.targetAssembler.assemble(context);
            List<StructureHit> hits = this.scoreHits(context);
            this.logHitTimings(context.getId(), hits.size(), result.getTimings().getScoreHitsTime());
            result.getTargetStructures().clear();
            result.setTargetStructures(null);
            result.setHits(hits);
            result.getTimings().queryStop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Throwable t = StrucmotifRuntimeImpl.unwrapException(e);
            if (t instanceof IllegalQueryDefinitionException) {
                throw (IllegalQueryDefinitionException)t;
            }
            throw new RuntimeException(e);
        }
    }

    private void logHitTimings(String ctx, int count, long time) {
        logger.info("[{}] Accepted {} hits in {} ms", new Object[]{ctx, count, time});
    }

    @Override
    public void performSearch(StructureSearchContext context, Consumer<StructureHit> consumer) {
        try {
            StructureSearchResult result = context.getResult();
            this.targetAssembler.assemble(context);
            int hits = this.consumeHits(context, consumer);
            this.logHitTimings(context.getId(), hits, result.getTimings().getScoreHitsTime());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Throwable t = StrucmotifRuntimeImpl.unwrapException(e);
            if (t instanceof IllegalQueryDefinitionException) {
                throw (IllegalQueryDefinitionException)t;
            }
            throw new RuntimeException(e);
        }
    }

    private static Throwable unwrapException(Throwable throwable) {
        Throwable rootCause;
        Objects.requireNonNull(throwable);
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    private List<StructureHit> scoreHits(StructureSearchContext context) throws ExecutionException, InterruptedException {
        StructureQuery query = context.getQuery();
        StructureParameters parameters = query.getParameters();
        StructureSearchResult result = context.getResult();
        result.getTimings().scoreHitsStart();
        int limit = Math.min(parameters.getLimit(), this.strucmotifConfig.getMaxResults());
        HitScorer hitScorer = new HitScorer(query.getQueryStructure().getResidues(), parameters.getAtomPairingScheme(), this.alignmentService);
        List hits = this.threadPool.submit(() -> this.hits(context, hitScorer).limit(limit).collect(Collectors.toList())).get();
        result.getTimings().scoreHitsStop();
        return hits;
    }

    private int consumeHits(StructureSearchContext context, Consumer<StructureHit> consumer) throws ExecutionException, InterruptedException {
        StructureQuery query = context.getQuery();
        StructureParameters parameters = query.getParameters();
        StructureSearchResult result = context.getResult();
        result.getTimings().scoreHitsStart();
        AtomicInteger hits = new AtomicInteger();
        HitScorer hitScorer = new HitScorer(query.getQueryStructure().getResidues(), parameters.getAtomPairingScheme(), this.alignmentService);
        this.threadPool.submit(() -> {
            this.hits(context, hitScorer).forEach(hit -> {
                hits.incrementAndGet();
                consumer.accept((StructureHit)hit);
            });
            return null;
        }).get();
        result.getTimings().scoreHitsStop();
        return hits.get();
    }

    private Stream<StructureHit> hits(StructureSearchContext context, HitScorer hitScorer) {
        StructureQuery query = context.getQuery();
        List<Integer> residueIndexSwaps = query.getQueryStructure().getResidueIndexSwaps();
        StructureParameters parameters = query.getParameters();
        StructureIndexProvider structureIndexProvider = context.getStructureIndexProvider();
        StructureDataProvider structureDataProvider = context.getStructureDataProvider();
        return context.getResult().getTargetStructures().values().parallelStream().flatMap(targetStructure -> {
            String structureIdentifier = structureIndexProvider.selectStructureIdentifier(targetStructure.getStructureIndex());
            Structure structure = structureDataProvider.readRenumbered(structureIdentifier);
            return targetStructure.paths(residueIndexSwaps, structure, structureIdentifier, hitScorer, parameters.getRmsdCutoff(), this.assemblyInformationProvider, parameters.isUndefinedAssemblies());
        });
    }

    @Override
    public void performSearch(MotifSearchContext context) {
        try {
            MotifSearchResult result = context.getResult();
            List hits = this.threadPool.submit(() -> context.getQuery().getMotifDefinitions().parallelStream().flatMap(motif -> {
                StructureSearchResult subresult = this.performSearch(context, (EnrichedMotifDefinition)motif);
                List<StructureHit> subhits = subresult.getHits();
                if (subhits.isEmpty()) {
                    return Stream.empty();
                }
                logger.info("[{}] {} occurrences of {} found", new Object[]{context.getId(), subhits.size(), motif.getMotifIdentifier()});
                return subresult.getHits().stream().map(h -> this.createSubhit((MotifDefinition)motif, (StructureHit)h));
            }).collect(Collectors.toList())).get();
            result.setHits(hits);
            result.getTimings().queryStop();
            this.logHitTimings(context.getId(), hits.size(), result.getTimings().getQueryTime());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Throwable t = StrucmotifRuntimeImpl.unwrapException(e);
            if (t instanceof IllegalQueryDefinitionException) {
                throw (IllegalQueryDefinitionException)t;
            }
            throw new RuntimeException(e);
        }
    }

    private StructureSearchResult performSearch(MotifSearchContext context, EnrichedMotifDefinition motifDefinition) {
        StructureSearchContext subcontext = context.createSubcontext(motifDefinition);
        logger.info("[{}] Evaluating {} in subquery [{}]", new Object[]{context.getId(), motifDefinition.getMotifIdentifier(), subcontext.getId()});
        this.performSearch(subcontext);
        return subcontext.getResult();
    }

    @Override
    public void performSearch(MotifSearchContext context, Consumer<MotifHit> consumer) {
        try {
            MotifSearchResult result = context.getResult();
            int hits = this.consumeHits(context, consumer);
            this.logHitTimings(context.getId(), hits, result.getTimings().getQueryTime());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Throwable t = StrucmotifRuntimeImpl.unwrapException(e);
            if (t instanceof IllegalQueryDefinitionException) {
                throw (IllegalQueryDefinitionException)t;
            }
            throw new RuntimeException(e);
        }
    }

    private int consumeHits(MotifSearchContext context, Consumer<MotifHit> consumer) throws ExecutionException, InterruptedException {
        MotifSearchResult result = context.getResult();
        AtomicInteger hits = new AtomicInteger();
        this.threadPool.submit(() -> {
            context.getQuery().getMotifDefinitions().parallelStream().forEach(motif -> {
                StructureSearchResult subresult = this.performSearch(context, (EnrichedMotifDefinition)motif);
                List<StructureHit> subhits = subresult.getHits();
                if (subhits.isEmpty()) {
                    return;
                }
                int subhitCount = subhits.size();
                logger.info("[{}] {} occurrences of {} found", new Object[]{context.getId(), subhitCount, motif.getMotifIdentifier()});
                hits.addAndGet(subhitCount);
                subresult.getHits().stream().map(h -> this.createSubhit((MotifDefinition)motif, (StructureHit)h)).forEach(consumer);
            });
            return null;
        }).get();
        result.getTimings().queryStop();
        return hits.get();
    }

    private MotifHit createSubhit(MotifDefinition motifDefinition, StructureHit structureHit) {
        return new MotifHit(motifDefinition.getMotifIdentifier(), structureHit.getLabelSelections(), structureHit.getResidueTypes(), structureHit.getRootMeanSquareDeviation(), structureHit.getTransformation());
    }
}

