/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.domain.SearchContext;
import org.rcsb.strucmotif.domain.query.Parameters;
import org.rcsb.strucmotif.domain.query.QueryStructure;
import org.rcsb.strucmotif.domain.result.Hit;

public abstract class AbstractSearchContext<P extends Parameters, S extends QueryStructure, H extends Hit>
implements SearchContext<P, S, H> {
    protected static final String COLUMN_DELIMITER = ",";
    protected static final String VALUE_DELIMITER = ";";
    protected final String id = String.valueOf(this.hashCode());

    protected AbstractSearchContext() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void runAndWriteToPath(Path path) {
        try {
            Files.writeString(path, (CharSequence)this.composeHeader(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.runAndConsume(hit -> {
            String output = this.composeOutput(hit);
            try {
                Files.writeString(path, (CharSequence)output, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    protected abstract String composeHeader();

    protected abstract String composeOutput(H var1);

    protected String toString(Collection<?> collection) {
        return collection.stream().map(Object::toString).collect(Collectors.joining(VALUE_DELIMITER, "[", "]"));
    }

    protected float truncate(float value, int decimalPlaces) {
        return BigDecimal.valueOf(value).setScale(decimalPlaces, RoundingMode.HALF_UP).floatValue();
    }
}

