/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.core.StrucmotifRuntime;
import org.rcsb.strucmotif.domain.AbstractSearchContext;
import org.rcsb.strucmotif.domain.StructureSearchContext;
import org.rcsb.strucmotif.domain.motif.EnrichedMotifDefinition;
import org.rcsb.strucmotif.domain.query.MotifParameters;
import org.rcsb.strucmotif.domain.query.MotifQueryStructure;
import org.rcsb.strucmotif.domain.query.MotifSearchQuery;
import org.rcsb.strucmotif.domain.query.PositionSpecificExchange;
import org.rcsb.strucmotif.domain.query.ResultsContentType;
import org.rcsb.strucmotif.domain.query.StructureParameters;
import org.rcsb.strucmotif.domain.query.StructureQuery;
import org.rcsb.strucmotif.domain.result.MotifHit;
import org.rcsb.strucmotif.domain.result.MotifSearchResult;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.io.InvertedIndex;
import org.rcsb.strucmotif.io.StructureDataProvider;
import org.rcsb.strucmotif.io.StructureIndexProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotifSearchContext
extends AbstractSearchContext<MotifParameters, MotifQueryStructure, MotifHit> {
    private static final Logger logger = LoggerFactory.getLogger(MotifSearchContext.class);
    private static final Collection<ResultsContentType> DEFAULT_CONTENT_TYPES = EnumSet.of(ResultsContentType.EXPERIMENTAL, ResultsContentType.COMPUTATIONAL);
    private final StrucmotifRuntime runtime;
    private final StrucmotifConfig config;
    private final InvertedIndex invertedIndex;
    private final StructureIndexProvider structureIndexProvider;
    private final StructureDataProvider structureDataProvider;
    private final MotifSearchQuery query;
    private final MotifSearchResult result;

    public MotifSearchContext(StrucmotifRuntime strucmotifRuntime, StrucmotifConfig strucmotifConfig, InvertedIndex invertedIndex, StructureIndexProvider structureIndexProvider, StructureDataProvider structureDataProvider, MotifSearchQuery query) {
        this.runtime = strucmotifRuntime;
        this.config = strucmotifConfig;
        this.invertedIndex = invertedIndex;
        this.structureIndexProvider = structureIndexProvider;
        this.structureDataProvider = structureDataProvider;
        this.query = query;
        this.result = this.initializeResultContainer();
    }

    private MotifSearchResult initializeResultContainer() {
        MotifQueryStructure queryStructure = this.query.getQueryStructure();
        MotifParameters parameters = this.query.getParameters();
        logger.info("[{}] Query: {}", (Object)this.id, (Object)queryStructure.getStructureIdentifier());
        logger.info("[{}] Tolerances: [{}, {}, {}], Atom Pairing Scheme: {}, RMSD Cutoff: {}", new Object[]{this.id, parameters.getBackboneDistanceTolerance(), parameters.getSideChainDistanceTolerance(), parameters.getAngleTolerance(), parameters.getAtomPairingScheme(), Float.valueOf(parameters.getRmsdCutoff())});
        return new MotifSearchResult();
    }

    @Override
    public StrucmotifRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public StrucmotifConfig getConfig() {
        return this.config;
    }

    @Override
    public InvertedIndex getInvertedIndex() {
        return this.invertedIndex;
    }

    @Override
    public StructureIndexProvider getStructureIndexProvider() {
        return this.structureIndexProvider;
    }

    @Override
    public StructureDataProvider getStructureDataProvider() {
        return this.structureDataProvider;
    }

    public MotifSearchQuery getQuery() {
        return this.query;
    }

    public MotifSearchResult run() {
        this.runtime.performSearch(this);
        return this.getResult();
    }

    @Override
    public void runAndConsume(Consumer<MotifHit> hitConsumer) {
        this.getRuntime().performSearch(this, hitConsumer);
    }

    @Override
    protected String composeHeader() {
        return "motif_id,rmsd_score,residue_ids,residue_types,transformation" + System.lineSeparator();
    }

    @Override
    protected String composeOutput(MotifHit hit) {
        float[] original = hit.getTransformation().getFlattenedTransformation();
        ArrayList<Float> matrix = new ArrayList<Float>();
        for (float v : original) {
            matrix.add(Float.valueOf(this.truncate(v, this.config.getDecimalPlacesMatrix())));
        }
        return hit.getMotifIdentifier() + "," + this.truncate(hit.getRootMeanSquareDeviation(), this.config.getDecimalPlacesScore()) + "," + this.toString(hit.getLabelSelections()) + "," + this.toString(hit.getResidueTypes()) + "," + this.toString(matrix) + System.lineSeparator();
    }

    public MotifSearchResult getResult() {
        return this.result;
    }

    public StructureSearchContext createSubcontext(EnrichedMotifDefinition motifDefinition) {
        MotifParameters parentParameters = this.query.getParameters();
        StructureParameters parameters = new StructureParameters(parentParameters.getBackboneDistanceTolerance(), parentParameters.getSideChainDistanceTolerance(), parentParameters.getAngleTolerance(), parentParameters.getRmsdCutoff(), parentParameters.getAtomPairingScheme(), parentParameters.getMotifPruner(), Integer.MAX_VALUE, false);
        Map<LabelSelection, Set<ResidueType>> exchanges = motifDefinition.getPositionSpecificExchanges().stream().collect(Collectors.toMap(PositionSpecificExchange::getLabelSelection, PositionSpecificExchange::getResidueTypes));
        StructureQuery structureQuery = new StructureQuery(motifDefinition.getStructureIdentifier(), motifDefinition.getStructure(), motifDefinition.getLabelSelections(), motifDefinition.getResidues(), parameters, exchanges, Collections.emptySet(), Collections.emptySet(), DEFAULT_CONTENT_TYPES, this.config);
        return new StructureSearchContext(this.runtime, this.config, this.invertedIndex, this.structureIndexProvider, this.structureDataProvider, structureQuery);
    }
}

