/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.core.StrucmotifRuntime;
import org.rcsb.strucmotif.domain.AbstractSearchContext;
import org.rcsb.strucmotif.domain.query.StructureParameters;
import org.rcsb.strucmotif.domain.query.StructureQuery;
import org.rcsb.strucmotif.domain.query.StructureQueryStructure;
import org.rcsb.strucmotif.domain.result.StructureHit;
import org.rcsb.strucmotif.domain.result.StructureSearchResult;
import org.rcsb.strucmotif.io.InvertedIndex;
import org.rcsb.strucmotif.io.StructureDataProvider;
import org.rcsb.strucmotif.io.StructureIndexProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureSearchContext
extends AbstractSearchContext<StructureParameters, StructureQueryStructure, StructureHit> {
    private static final Logger logger = LoggerFactory.getLogger(StructureSearchContext.class);
    private final StrucmotifRuntime runtime;
    private final StrucmotifConfig config;
    private final InvertedIndex invertedIndex;
    private final StructureIndexProvider structureIndexProvider;
    private final StructureDataProvider structureDataProvider;
    private final StructureQuery query;
    private final StructureSearchResult result;

    public StructureSearchContext(StrucmotifRuntime strucmotifRuntime, StrucmotifConfig strucmotifConfig, InvertedIndex invertedIndex, StructureIndexProvider structureIndexProvider, StructureDataProvider structureDataProvider, StructureQuery query) {
        this.runtime = strucmotifRuntime;
        this.config = strucmotifConfig;
        this.invertedIndex = invertedIndex;
        this.structureIndexProvider = structureIndexProvider;
        this.structureDataProvider = structureDataProvider;
        this.query = query;
        this.result = this.initializeResultContainer();
    }

    private StructureSearchResult initializeResultContainer() {
        StructureQueryStructure queryStructure = this.query.getQueryStructure();
        StructureParameters parameters = this.query.getParameters();
        logger.info("[{}] Query: {} with {}", new Object[]{this.id, queryStructure.getStructureIdentifier(), queryStructure.getIndexSelections()});
        logger.info("[{}] Exchanges: {}, Tolerances: [{}, {}, {}], Atom Pairing Scheme: {}, RMSD Cutoff: {}, Limit: {}", new Object[]{this.id, this.query.getExchanges(), parameters.getBackboneDistanceTolerance(), parameters.getSideChainDistanceTolerance(), parameters.getAngleTolerance(), parameters.getAtomPairingScheme(), Float.valueOf(parameters.getRmsdCutoff()), parameters.getLimit()});
        return new StructureSearchResult();
    }

    @Override
    public StrucmotifRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public StrucmotifConfig getConfig() {
        return this.config;
    }

    @Override
    public InvertedIndex getInvertedIndex() {
        return this.invertedIndex;
    }

    @Override
    public StructureIndexProvider getStructureIndexProvider() {
        return this.structureIndexProvider;
    }

    @Override
    public StructureDataProvider getStructureDataProvider() {
        return this.structureDataProvider;
    }

    public StructureQuery getQuery() {
        return this.query;
    }

    public StructureSearchResult run() {
        this.runtime.performSearch(this);
        return this.getResult();
    }

    @Override
    public void runAndConsume(Consumer<StructureHit> hitConsumer) {
        this.getRuntime().performSearch(this, hitConsumer);
    }

    @Override
    protected String composeHeader() {
        return "pdb_id,assembly_id,rmsd_score,residue_ids,residue_types,transformation" + System.lineSeparator();
    }

    @Override
    protected String composeOutput(StructureHit hit) {
        float[] original = hit.getTransformation().getFlattenedTransformation();
        ArrayList<Float> matrix = new ArrayList<Float>();
        for (float v : original) {
            matrix.add(Float.valueOf(this.truncate(v, this.config.getDecimalPlacesMatrix())));
        }
        return hit.getStructureIdentifier() + "," + hit.getAssemblyIdentifier() + "," + this.truncate(hit.getRootMeanSquareDeviation(), this.config.getDecimalPlacesScore()) + "," + this.toString(hit.getLabelSelections()) + "," + this.toString(hit.getResidueTypes()) + "," + this.toString(matrix) + System.lineSeparator();
    }

    public StructureSearchResult getResult() {
        return this.result;
    }
}

