/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain;

import java.util.Arrays;
import org.rcsb.strucmotif.math.Algebra;

public class Transformation {
    public static final String DEFAULT_OPERATOR = "1";
    public static final float[][] IDENTITY_MATRIX_3D = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
    public static final float[][] IDENTITY_MATRIX_4D = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
    public static final Transformation IDENTITY_TRANSFORMATION = new Transformation(IDENTITY_MATRIX_4D){

        @Override
        public void transform(float[] out, float[] v) {
            System.arraycopy(v, 0, out, 0, 3);
        }
    };
    private final float[][] transformation;

    private Transformation(float[][] transformation) {
        this.transformation = transformation;
    }

    public static Transformation of(float[][] transformation) {
        if (Arrays.deepEquals((Object[])IDENTITY_MATRIX_4D, (Object[])transformation)) {
            return IDENTITY_TRANSFORMATION;
        }
        return new Transformation(transformation);
    }

    public float[][] getTransformationMatrix() {
        return this.transformation;
    }

    public float[] getFlattenedTransformation() {
        float[] out = new float[16];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.transformation[i], 0, out, i * 4, 4);
        }
        return out;
    }

    public void transform(float[] out, float[] v) {
        Algebra.multiply4d(out, this.transformation, v);
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.transformation);
    }
}

