/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.align;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rcsb.strucmotif.domain.align.AtomPairingScheme;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.math.Algebra;

public class AtomCorrespondence {
    private final float[] referenceCentroid;
    private final float[] candidateCentroid;
    private final List<float[]> centeredReferenceVectors;
    private final List<float[]> centeredCandidateVectors;

    public AtomCorrespondence(List<Map<LabelAtomId, float[]>> reference, List<Map<LabelAtomId, float[]>> candidate, AtomPairingScheme atomPairingScheme) {
        Map<float[], float[]> mapping = AtomCorrespondence.pairAtomsByName(reference, candidate, atomPairingScheme);
        this.referenceCentroid = Algebra.centroid3d(mapping.keySet());
        this.candidateCentroid = Algebra.centroid3d(mapping.values());
        this.centeredReferenceVectors = AtomCorrespondence.center(mapping.keySet(), this.referenceCentroid);
        this.centeredCandidateVectors = AtomCorrespondence.center(mapping.values(), this.candidateCentroid);
    }

    private static Map<float[], float[]> pairAtomsByName(List<Map<LabelAtomId, float[]>> reference, List<Map<LabelAtomId, float[]>> candidate, AtomPairingScheme atomPairingScheme) {
        LinkedHashMap<float[], float[]> mapping = new LinkedHashMap<float[], float[]>();
        boolean schemeRequiresSubset = atomPairingScheme != AtomPairingScheme.ALL;
        for (int i = 0; i < reference.size(); ++i) {
            Map<LabelAtomId, float[]> referenceGroup = reference.get(i);
            Map<LabelAtomId, float[]> candidateGroup = candidate.get(i);
            for (Map.Entry<LabelAtomId, float[]> referenceAtom : referenceGroup.entrySet()) {
                float[] candidateAtom;
                LabelAtomId referenceLabel = referenceAtom.getKey();
                float[] referenceVector = referenceAtom.getValue();
                if (schemeRequiresSubset && !atomPairingScheme.test(referenceLabel) || (candidateAtom = candidateGroup.get((Object)referenceLabel)) == null) continue;
                mapping.put(referenceVector, candidateAtom);
            }
        }
        if (mapping.isEmpty()) {
            throw new IllegalStateException("Found empty pairing of atoms");
        }
        return mapping;
    }

    public List<float[]> getCenteredReferenceVectors() {
        return this.centeredReferenceVectors;
    }

    public float[] getReferenceCentroid() {
        return this.referenceCentroid;
    }

    public List<float[]> getCenteredCandidateVectors() {
        return this.centeredCandidateVectors;
    }

    public float[] getCandidateCentroid() {
        return this.candidateCentroid;
    }

    private static List<float[]> center(Collection<float[]> container, float[] centroid) {
        ArrayList<float[]> out = new ArrayList<float[]>();
        for (float[] atom : container) {
            float[] v = new float[3];
            Algebra.subtract3d(v, atom, centroid);
            out.add(v);
        }
        return out;
    }
}

