/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.align;

import java.util.function.Predicate;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;

public enum AtomPairingScheme implements Predicate<LabelAtomId>
{
    ALL(s -> true),
    ALPHA_CARBON(s -> s.equals((Object)LabelAtomId.CA) || s.equals((Object)LabelAtomId.C4_PRIME)),
    BETA_CARBON(s -> s.equals((Object)LabelAtomId.CB) || s.equals((Object)LabelAtomId.C1_PRIME)),
    BACKBONE(s -> s.equals((Object)LabelAtomId.N) || s.equals((Object)LabelAtomId.CA) || s.equals((Object)LabelAtomId.C) || s.equals((Object)LabelAtomId.O) || s.equals((Object)LabelAtomId.P) || s.equals((Object)LabelAtomId.OP1) || s.equals((Object)LabelAtomId.OP2) || s.equals((Object)LabelAtomId.C2_PRIME) || s.equals((Object)LabelAtomId.C3_PRIME) || s.equals((Object)LabelAtomId.O3_PRIME) || s.equals((Object)LabelAtomId.C4_PRIME) || s.equals((Object)LabelAtomId.O4_PRIME) || s.equals((Object)LabelAtomId.C5_PRIME) || s.equals((Object)LabelAtomId.O5_PRIME)),
    SIDE_CHAIN(AtomPairingScheme.BACKBONE.predicate.negate()),
    PSEUDO_ATOMS(s -> s.equals((Object)LabelAtomId.CA) || s.equals((Object)LabelAtomId.CB) || s.equals((Object)LabelAtomId.C4_PRIME) || s.equals((Object)LabelAtomId.C1_PRIME));

    private final Predicate<LabelAtomId> predicate;

    private AtomPairingScheme(Predicate<LabelAtomId> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(LabelAtomId s) {
        return this.predicate.test(s);
    }
}

