/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.bucket;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.domain.bucket.Bucket;
import org.rcsb.strucmotif.domain.motif.InvertedIndexResiduePairIdentifier;
import org.rcsb.strucmotif.domain.motif.ResiduePairIdentifier;

public class InvertedIndexBucket
implements Bucket {
    private static final Map<Integer, String> EMPTY_MAP = Collections.emptyMap();
    private static final int[] EMPTY_ARRAY = new int[0];
    public static final InvertedIndexBucket EMPTY_BUCKET = new InvertedIndexBucket(EMPTY_ARRAY, EMPTY_ARRAY, EMPTY_ARRAY, EMPTY_ARRAY, new String[0]){

        @Override
        public boolean hasNextStructure() {
            return false;
        }

        @Override
        public boolean hasNextOccurrence() {
            return false;
        }
    };
    private final int[] structureIndices;
    private final int[] positionOffsets;
    private final int[] positionData;
    private int structurePointer;
    private int positionPointer;
    private int lastPosition;
    private final Map<Integer, String> operators;

    public InvertedIndexBucket(int[] structureIndices, int[] positionOffsets, int[] positionData, int[] operatorIndices, String[] operatorData) {
        this.structureIndices = structureIndices;
        this.positionOffsets = positionOffsets;
        this.positionData = positionData;
        if (operatorIndices.length > 0) {
            this.operators = new HashMap<Integer, String>();
            for (int i = 0; i < operatorIndices.length; ++i) {
                this.operators.put(operatorIndices[i], operatorData[i]);
            }
        } else {
            this.operators = EMPTY_MAP;
        }
        this.structurePointer = -1;
    }

    private void syncStructureState() {
        if (this.structurePointer >= this.positionOffsets.length) {
            throw new NoSuchElementException("No next structure");
        }
        this.positionPointer = this.positionOffsets[this.structurePointer] - 2;
        this.lastPosition = this.hasNextStructure() ? this.positionOffsets[this.structurePointer + 1] : this.positionData.length;
    }

    @Override
    public int getStructureCount() {
        return this.structureIndices.length;
    }

    @Override
    public int getResiduePairCount() {
        return this.positionData.length / 2;
    }

    @Override
    public Set<Integer> getStructureIndices() {
        return Arrays.stream(this.structureIndices).boxed().collect(Collectors.toSet());
    }

    @Override
    public boolean hasNextStructure() {
        return this.structurePointer + 1 < this.positionOffsets.length;
    }

    @Override
    public void moveStructure() {
        ++this.structurePointer;
        this.syncStructureState();
    }

    @Override
    public boolean hasNextOccurrence() {
        return this.positionPointer + 2 < this.lastPosition;
    }

    @Override
    public void moveOccurrence() {
        this.positionPointer += 2;
        if (this.positionPointer > this.lastPosition) {
            throw new IllegalStateException("Can't move to occurrence in another structure without calling moveStructure() first");
        }
    }

    public int[] getOccurrencePositions() {
        int start = this.positionOffsets[this.structurePointer];
        int end = this.lastPosition;
        int[] out = new int[(end - start) / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = start + i * 2;
        }
        return out;
    }

    @Override
    public int getStructureIndex() {
        return this.structureIndices[this.structurePointer];
    }

    public int getStructureIndex(int i) {
        return this.structureIndices[i];
    }

    @Override
    public int getIndex1() {
        return this.positionData[this.positionPointer];
    }

    public int getIndex(int i) {
        return this.positionData[i];
    }

    @Override
    public int getIndex2() {
        return this.positionData[this.positionPointer + 1];
    }

    @Override
    public String getStructOperId1() {
        return this.operators.getOrDefault(this.positionPointer, "1");
    }

    public String getStructOperId(int i) {
        return this.operators.getOrDefault(i, "1");
    }

    @Override
    public String getStructOperId2() {
        return this.operators.getOrDefault(this.positionPointer + 1, "1");
    }

    @Override
    public ResiduePairIdentifier getResiduePairIdentifier() {
        return new InvertedIndexResiduePairIdentifier(this.getIndex1(), this.getIndex2(), this.getStructOperId1(), this.getStructOperId2());
    }

    @Override
    public void reset() {
        this.structurePointer = -1;
    }
}

