/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.bucket;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.rcsb.strucmotif.domain.bucket.Bucket;
import org.rcsb.strucmotif.domain.motif.ResiduePairIdentifier;

public class ResiduePairIdentifierBucket
implements Bucket {
    private final Map<Integer, Collection<ResiduePairIdentifier>> data;
    private Iterator<Map.Entry<Integer, Collection<ResiduePairIdentifier>>> structureIterator;
    private final int residuePairCount;
    private Map.Entry<Integer, Collection<ResiduePairIdentifier>> currentStructure;
    private Iterator<ResiduePairIdentifier> identifierIterator;
    private ResiduePairIdentifier currentIdentifier;

    public ResiduePairIdentifierBucket(Map<Integer, Collection<ResiduePairIdentifier>> data) {
        this.data = data;
        this.structureIterator = data.entrySet().iterator();
        this.residuePairCount = data.values().stream().mapToInt(Collection::size).sum();
    }

    @Override
    public Set<Integer> getStructureIndices() {
        return this.data.keySet();
    }

    @Override
    public boolean hasNextStructure() {
        return this.structureIterator.hasNext();
    }

    @Override
    public boolean hasNextOccurrence() {
        return this.identifierIterator.hasNext();
    }

    @Override
    public void moveStructure() {
        this.currentStructure = this.structureIterator.next();
        this.identifierIterator = this.currentStructure.getValue().iterator();
    }

    @Override
    public void moveOccurrence() {
        this.currentIdentifier = this.identifierIterator.next();
    }

    @Override
    public int getStructureCount() {
        return this.data.size();
    }

    @Override
    public int getResiduePairCount() {
        return this.residuePairCount;
    }

    @Override
    public int getStructureIndex() {
        return this.currentStructure.getKey();
    }

    @Override
    public int getIndex1() {
        return this.currentIdentifier.getIndex1();
    }

    @Override
    public int getIndex2() {
        return this.currentIdentifier.getIndex2();
    }

    @Override
    public String getStructOperId1() {
        return this.currentIdentifier.getStructOperId1();
    }

    @Override
    public String getStructOperId2() {
        return this.currentIdentifier.getStructOperId2();
    }

    @Override
    public ResiduePairIdentifier getResiduePairIdentifier() {
        return this.currentIdentifier;
    }

    @Override
    public void reset() {
        this.structureIterator = this.data.entrySet().iterator();
    }
}

