/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.motif;

import org.rcsb.strucmotif.math.Algebra;

public enum AngleType {
    A0,
    A20,
    A40,
    A60,
    A80,
    A100,
    A120,
    A140,
    A160,
    A180;

    public static final int BIN_SIZE = 20;

    public int getIntRepresentation() {
        return this.ordinal() * 20;
    }

    public static AngleType ofAngle(float angle) {
        int i = Math.round(angle / 20.0f);
        if (i < 0) {
            return A0;
        }
        if (i >= AngleType.values().length) {
            return A180;
        }
        return AngleType.values()[i];
    }

    public static AngleType ofIntRepresentation(int ordinal) {
        return AngleType.values()[Algebra.capToInterval(0, ordinal, AngleType.values().length)];
    }
}

