/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.motif;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.rcsb.strucmotif.domain.motif.MotifDefinition;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.Structure;

public class EnrichedMotifDefinition
extends MotifDefinition {
    private final Structure structure;
    private final List<Map<LabelAtomId, float[]>> residues;

    public EnrichedMotifDefinition(MotifDefinition motifDefinition, Structure structure, List<Map<LabelAtomId, float[]>> residues) {
        super(motifDefinition.getMotifIdentifier(), motifDefinition.getStructureIdentifier(), motifDefinition.getTitle(), motifDefinition.getDescription(), motifDefinition.getLabelSelections(), motifDefinition.getPositionSpecificExchanges());
        this.structure = structure;
        this.residues = residues;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<Map<LabelAtomId, float[]>> getResidues() {
        return this.residues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnrichedMotifDefinition that = (EnrichedMotifDefinition)o;
        return Objects.equals(this.structure, that.structure) && Objects.equals(this.residues, that.residues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.structure, this.residues);
    }
}

