/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.motif;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.rcsb.strucmotif.domain.query.PositionSpecificExchange;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;

public class MotifDefinition {
    public static final MotifDefinition HDS = new MotifDefinition("HDS", "4cha", "catalytic triad", "Many proteases use serine as a nucleophilic residue during catalysis. The catalytic triad is composed of three residues, which are commonly distributed over two polypeptide chains. Most proteases are zymogens that require activation by proteolytic processing to prevent uncontrolled digestion of proteins within the cell.", List.of(new LabelSelection("B", "1", 42), new LabelSelection("B", "1", 87), new LabelSelection("C", "1", 47)));
    public static final MotifDefinition KDDDE = new MotifDefinition("KDDDE", "1lap", "aminopeptidase", "Aminopeptidases play important roles in protein degradation by removing residue from the N-terminus of a of polypeptide chains. The active site of leucine aminopeptidase contains two nearby zinc ions.", List.of(new LabelSelection("A", "1", 250), new LabelSelection("A", "1", 255), new LabelSelection("A", "1", 273), new LabelSelection("A", "1", 332), new LabelSelection("A", "1", 334)));
    public static final MotifDefinition CHH = new MotifDefinition("CHH", "1g2f", "simplified zinc finger", "DNA binding proteins often contain His2/Cys2 zinc fingers. These motifs are composed of two cysteine and two histidine residues which adopt a \u03b2\u03b2\u03b1 structure wrapping around a single zinc ion.", List.of(new LabelSelection("F", "1", 7), new LabelSelection("F", "1", 25), new LabelSelection("F", "1", 29)));
    public static final MotifDefinition CHCH = new MotifDefinition("CHCH", "1g2f", "original zinc finger", "DNA binding proteins often contain His2/Cys2 zinc fingers. These motifs are composed of two cysteine and two histidine residues which adopt a \u03b2\u03b2\u03b1 structure wrapping around a single zinc ion.", List.of(new LabelSelection("F", "1", 7), new LabelSelection("F", "1", 12), new LabelSelection("F", "1", 25), new LabelSelection("F", "1", 29)));
    public static final MotifDefinition KDEEH = new MotifDefinition("KDEEH", "2mnr", "enolase superfamily", "The enolase superfamily refers to a group of proteins diverse in sequence and structure that are all capable of abstracting a proton from a carboxylic acid. Isofunctional exchanges are crucial to represent this superfamily accurately by a structural motif.", List.of(new LabelSelection("A", "1", 162), new LabelSelection("A", "1", 193), new LabelSelection("A", "1", 219), new LabelSelection("A", "1", 245), new LabelSelection("A", "1", 295)));
    public static final MotifDefinition KDEEH_EXCHANGES = new MotifDefinition("KDEEH_EXCHANGES", "2mnr", "enolase superfamily with exchanges", "The enolase superfamily refers to a group of proteins diverse in sequence and structure that are all capable of abstracting a proton from a carboxylic acid. Isofunctional exchanges are crucial to represent this superfamily accurately by a structural motif.", List.of(new LabelSelection("A", "1", 162), new LabelSelection("A", "1", 193), new LabelSelection("A", "1", 219), new LabelSelection("A", "1", 245), new LabelSelection("A", "1", 295)), Set.of(new PositionSpecificExchange(new LabelSelection("A", "1", 162), ResidueType.LYSINE, ResidueType.HISTIDINE), new PositionSpecificExchange(new LabelSelection("A", "1", 245), ResidueType.GLUTAMIC_ACID, ResidueType.ASPARTIC_ACID, ResidueType.ASPARAGINE), new PositionSpecificExchange(new LabelSelection("A", "1", 295), ResidueType.HISTIDINE, ResidueType.LYSINE)));
    public static final MotifDefinition GGGG = new MotifDefinition("GGGG", "3ibk", "RNA G-tetrad", "G-tetrads are a common association motif in RNA and DNA. They are exclusively composed of guanine and stabilized by Hoogsteen base pairings. The negative charges of four oxygen atoms coordinate monovalent ions such as K+ and individual tetrads tend to be stacked one on another.", List.of(new LabelSelection("A", "1", 4), new LabelSelection("A", "1", 10), new LabelSelection("B", "1", 4), new LabelSelection("B", "1", 10)));
    private final String motifIdentifier;
    private final String structureIdentifier;
    private final String title;
    private final String description;
    private final List<LabelSelection> labelSelections;
    private final Set<PositionSpecificExchange> positionSpecificExchanges;

    public MotifDefinition(String motifIdentifier, String structureIdentifier, String title, String description, List<LabelSelection> labelSelections) {
        this(motifIdentifier, structureIdentifier, title, description, labelSelections, Collections.emptySet());
    }

    public MotifDefinition(String motifIdentifier, String structureIdentifier, String title, String description, List<LabelSelection> labelSelections, Set<PositionSpecificExchange> positionSpecificExchanges) {
        this.motifIdentifier = motifIdentifier;
        this.structureIdentifier = structureIdentifier;
        this.title = title;
        this.description = description;
        this.labelSelections = labelSelections;
        this.positionSpecificExchanges = positionSpecificExchanges;
    }

    public String getStructureIdentifier() {
        return this.structureIdentifier;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<LabelSelection> getLabelSelections() {
        return this.labelSelections;
    }

    public Set<PositionSpecificExchange> getPositionSpecificExchanges() {
        return this.positionSpecificExchanges;
    }

    public String getMotifIdentifier() {
        return this.motifIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MotifDefinition that = (MotifDefinition)o;
        return Objects.equals(this.motifIdentifier, that.motifIdentifier) && Objects.equals(this.structureIdentifier, that.structureIdentifier) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.labelSelections, that.labelSelections) && Objects.equals(this.positionSpecificExchanges, that.positionSpecificExchanges);
    }

    public int hashCode() {
        return Objects.hash(this.motifIdentifier, this.structureIdentifier, this.title, this.description, this.labelSelections, this.positionSpecificExchanges);
    }

    public String toString() {
        return "MotifDefinition{motifIdentifier='" + this.motifIdentifier + "', structureIdentifier='" + this.structureIdentifier + "', title='" + this.title + "', description='" + this.description + "', labelSelections=" + this.labelSelections + ", positionSpecificExchanges=" + this.positionSpecificExchanges + "}";
    }
}

