/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.motif;

import java.util.function.BiPredicate;
import org.rcsb.strucmotif.domain.motif.IndexSelectionResiduePairIdentifier;
import org.rcsb.strucmotif.domain.motif.InvertedIndexResiduePairIdentifier;
import org.rcsb.strucmotif.domain.structure.IndexSelection;

public enum Overlap implements BiPredicate<InvertedIndexResiduePairIdentifier, InvertedIndexResiduePairIdentifier>
{
    NONE{

        @Override
        public boolean test(InvertedIndexResiduePairIdentifier residuePairIdentifier1, InvertedIndexResiduePairIdentifier residuePairIdentifier2) {
            IndexSelection indexSelection11 = residuePairIdentifier1.getIndexSelection1();
            IndexSelection indexSelection12 = residuePairIdentifier1.getIndexSelection2();
            IndexSelection indexSelection21 = residuePairIdentifier2.getIndexSelection1();
            IndexSelection indexSelection22 = residuePairIdentifier2.getIndexSelection2();
            return !Overlap.testInternal(indexSelection11, indexSelection21) && !Overlap.testInternal(indexSelection12, indexSelection22) && !Overlap.testInternal(indexSelection11, indexSelection22) && !Overlap.testInternal(indexSelection12, indexSelection21);
        }
    }
    ,
    LEFT_LEFT{

        @Override
        public boolean test(InvertedIndexResiduePairIdentifier residuePairIdentifier1, InvertedIndexResiduePairIdentifier residuePairIdentifier2) {
            IndexSelection indexSelection11 = residuePairIdentifier1.getIndexSelection1();
            IndexSelection indexSelection21 = residuePairIdentifier2.getIndexSelection1();
            return Overlap.testInternal(indexSelection11, indexSelection21);
        }
    }
    ,
    LEFT_RIGHT{

        @Override
        public boolean test(InvertedIndexResiduePairIdentifier residuePairIdentifier1, InvertedIndexResiduePairIdentifier residuePairIdentifier2) {
            IndexSelection indexSelection11 = residuePairIdentifier1.getIndexSelection1();
            IndexSelection indexSelection22 = residuePairIdentifier2.getIndexSelection2();
            return Overlap.testInternal(indexSelection11, indexSelection22);
        }
    }
    ,
    RIGHT_LEFT{

        @Override
        public boolean test(InvertedIndexResiduePairIdentifier residuePairIdentifier1, InvertedIndexResiduePairIdentifier residuePairIdentifier2) {
            IndexSelection indexSelection12 = residuePairIdentifier1.getIndexSelection2();
            IndexSelection indexSelection21 = residuePairIdentifier2.getIndexSelection1();
            return Overlap.testInternal(indexSelection12, indexSelection21);
        }
    }
    ,
    RIGHT_RIGHT{

        @Override
        public boolean test(InvertedIndexResiduePairIdentifier residuePairIdentifier1, InvertedIndexResiduePairIdentifier residuePairIdentifier2) {
            IndexSelection indexSelection12 = residuePairIdentifier1.getIndexSelection2();
            IndexSelection indexSelection22 = residuePairIdentifier2.getIndexSelection2();
            return Overlap.testInternal(indexSelection12, indexSelection22);
        }
    };


    private static boolean testInternal(IndexSelection indexSelection1, IndexSelection indexSelection2) {
        return indexSelection1.getIndex() == indexSelection2.getIndex() && indexSelection1.getStructOperId().equals(indexSelection2.getStructOperId());
    }

    @Override
    public boolean test(InvertedIndexResiduePairIdentifier residuePairIdentifier1, InvertedIndexResiduePairIdentifier residuePairIdentifier2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Overlap ofResiduePairIdentifiers(IndexSelectionResiduePairIdentifier residuePairIdentifier1, IndexSelectionResiduePairIdentifier residuePairIdentifier2) {
        IndexSelection indexSelection11 = residuePairIdentifier1.getIndexSelection1();
        IndexSelection indexSelection12 = residuePairIdentifier1.getIndexSelection2();
        IndexSelection indexSelection21 = residuePairIdentifier2.getIndexSelection1();
        IndexSelection indexSelection22 = residuePairIdentifier2.getIndexSelection2();
        boolean equal1112 = indexSelection11.equals(indexSelection21);
        boolean equal1122 = indexSelection11.equals(indexSelection22);
        boolean equal1221 = indexSelection12.equals(indexSelection21);
        boolean equal1222 = indexSelection12.equals(indexSelection22);
        if (!(equal1112 || equal1122 || equal1221 || equal1222)) {
            return NONE;
        }
        if (equal1112) {
            return LEFT_LEFT;
        }
        if (equal1222) {
            return RIGHT_RIGHT;
        }
        if (equal1122) {
            return LEFT_RIGHT;
        }
        return RIGHT_LEFT;
    }
}

