/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.motif;

import java.util.Objects;
import org.rcsb.strucmotif.domain.motif.AngleType;
import org.rcsb.strucmotif.domain.motif.DistanceType;
import org.rcsb.strucmotif.domain.structure.ResidueType;

public class ResiduePairDescriptor {
    private final ResidueType residueType1;
    private final ResidueType residueType2;
    private final DistanceType backboneDistance;
    private final DistanceType sideChainDistance;
    private final AngleType angle;
    private final boolean flipped;

    public ResiduePairDescriptor(ResidueType residueType1, ResidueType residueType2, DistanceType backboneDistance, DistanceType sideChainDistance, AngleType angle) {
        this.flipped = residueType1.getInternalCode().compareTo(residueType2.getInternalCode()) > 0;
        this.residueType1 = this.flipped ? residueType2 : residueType1;
        this.residueType2 = this.flipped ? residueType1 : residueType2;
        this.backboneDistance = backboneDistance;
        this.sideChainDistance = sideChainDistance;
        this.angle = angle;
    }

    public ResidueType getResidueType1() {
        return this.residueType1;
    }

    public ResidueType getResidueType2() {
        return this.residueType2;
    }

    public DistanceType getBackboneDistance() {
        return this.backboneDistance;
    }

    public DistanceType getSideChainDistance() {
        return this.sideChainDistance;
    }

    public AngleType getAngle() {
        return this.angle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResiduePairDescriptor that = (ResiduePairDescriptor)o;
        return this.flipped == that.flipped && this.residueType1 == that.residueType1 && this.residueType2 == that.residueType2 && this.backboneDistance == that.backboneDistance && this.sideChainDistance == that.sideChainDistance && this.angle == that.angle;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.residueType1, this.residueType2, this.backboneDistance, this.sideChainDistance, this.angle, this.flipped});
    }

    public String toString() {
        return this.residueType1.getInternalCode() + this.residueType2.getInternalCode() + "-" + this.backboneDistance.getIntRepresentation() + "-" + this.sideChainDistance.getIntRepresentation() + "-" + this.angle.ordinal();
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public boolean isAmbiguous() {
        return this.residueType1 == this.residueType2;
    }
}

