/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.motif;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.rcsb.strucmotif.domain.motif.AngleType;
import org.rcsb.strucmotif.domain.motif.DistanceType;
import org.rcsb.strucmotif.domain.motif.ResiduePairDescriptor;
import org.rcsb.strucmotif.domain.motif.ResiduePairIdentifier;
import org.rcsb.strucmotif.domain.structure.IndexSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;

public class ResiduePairOccurrence {
    private final ResiduePairDescriptor residuePairDescriptor;
    private final ResiduePairIdentifier residuePairIdentifier;

    public ResiduePairOccurrence(ResiduePairDescriptor residuePairDescriptor, ResiduePairIdentifier residuePairIdentifier) {
        this.residuePairDescriptor = residuePairDescriptor;
        this.residuePairIdentifier = residuePairIdentifier;
    }

    public ResiduePairDescriptor getResiduePairDescriptor() {
        return this.residuePairDescriptor;
    }

    public ResiduePairIdentifier getResidueIdentifier() {
        return this.residuePairIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResiduePairOccurrence that = (ResiduePairOccurrence)o;
        return Objects.equals(this.residuePairDescriptor, that.residuePairDescriptor) && Objects.equals(this.residuePairIdentifier, that.residuePairIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.residuePairDescriptor, this.residuePairIdentifier);
    }

    public String toString() {
        return this.residuePairDescriptor + " -> " + this.residuePairIdentifier;
    }

    public Stream<ResiduePairDescriptor> residuePairDescriptorsByTolerance(int backboneTolerance, int sideChainTolerance, int angleTolerance, Map<IndexSelection, Set<ResidueType>> exchanges) {
        Set<ResidueType> residueTypes1 = exchanges.getOrDefault(this.residuePairIdentifier.getIndexSelection1(), Set.of(this.residuePairDescriptor.getResidueType1()));
        Set<ResidueType> residueTypes2 = exchanges.getOrDefault(this.residuePairIdentifier.getIndexSelection2(), Set.of(this.residuePairDescriptor.getResidueType2()));
        int backboneDistance = this.residuePairDescriptor.getBackboneDistance().ordinal();
        int sideChainDistance = this.residuePairDescriptor.getSideChainDistance().ordinal();
        int angle = this.residuePairDescriptor.getAngle().ordinal();
        ArrayList<ResiduePairDescriptor> combinations = new ArrayList<ResiduePairDescriptor>();
        for (int i = -backboneTolerance; i <= backboneTolerance; ++i) {
            int ii = backboneDistance + i;
            if (ii < 0 || ii >= DistanceType.values().length) continue;
            for (int j = -sideChainTolerance; j <= sideChainTolerance; ++j) {
                int ij = sideChainDistance + j;
                if (ij < 0 || ij >= DistanceType.values().length) continue;
                for (int k = -angleTolerance; k <= angleTolerance; ++k) {
                    int ik = angle + k;
                    if (ik < 0 || ik >= AngleType.values().length) continue;
                    for (ResidueType residueType1 : residueTypes1) {
                        for (ResidueType residueType2 : residueTypes2) {
                            ResiduePairDescriptor derivedResiduePairDescriptor = new ResiduePairDescriptor(residueType1, residueType2, DistanceType.values()[ii], DistanceType.values()[ij], AngleType.values()[ik]);
                            combinations.add(derivedResiduePairDescriptor);
                        }
                    }
                }
            }
        }
        return combinations.parallelStream();
    }
}

