/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.query;

import java.io.InputStream;
import java.util.Set;
import org.rcsb.strucmotif.config.MotifPruningStrategy;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.core.KruskalMotifPruner;
import org.rcsb.strucmotif.core.MotifPruner;
import org.rcsb.strucmotif.core.NoOperationMotifPruner;
import org.rcsb.strucmotif.core.StrucmotifRuntime;
import org.rcsb.strucmotif.domain.MotifSearchContext;
import org.rcsb.strucmotif.domain.align.AtomPairingScheme;
import org.rcsb.strucmotif.domain.motif.EnrichedMotifDefinition;
import org.rcsb.strucmotif.domain.query.ContextBuilder;
import org.rcsb.strucmotif.domain.query.MotifParameters;
import org.rcsb.strucmotif.domain.query.MotifSearchQuery;
import org.rcsb.strucmotif.domain.structure.ResidueGraph;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.InvertedIndex;
import org.rcsb.strucmotif.io.SingleStructureDataProvider;
import org.rcsb.strucmotif.io.SingleStructureIndexProvider;
import org.rcsb.strucmotif.io.SingleStructureInvertedIndex;
import org.rcsb.strucmotif.io.StructureDataProvider;
import org.rcsb.strucmotif.io.StructureIndexProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MotifContextBuilder
implements ContextBuilder {
    private final StructureDataProvider structureDataProvider;
    private final KruskalMotifPruner kruskalMotifPruner;
    private final NoOperationMotifPruner noOperationMotifPruner;
    private final StrucmotifRuntime strucmotifRuntime;
    private final StrucmotifConfig strucmotifConfig;

    @Autowired
    public MotifContextBuilder(StructureDataProvider structureDataProvider, KruskalMotifPruner kruskalMotifPruner, NoOperationMotifPruner noOperationMotifPruner, StrucmotifRuntime strucmotifRuntime, StrucmotifConfig strucmotifConfig) {
        this.structureDataProvider = structureDataProvider;
        this.kruskalMotifPruner = kruskalMotifPruner;
        this.noOperationMotifPruner = noOperationMotifPruner;
        this.strucmotifRuntime = strucmotifRuntime;
        this.strucmotifConfig = strucmotifConfig;
    }

    public MotifRegistryBuilder defineByPdbIdAndAssemblyId(String structureIdentifier, String assemblyIdentifier) {
        Structure structure = this.structureDataProvider.readOriginal(structureIdentifier);
        return this.defineByStructureAndAssemblyId(structure, assemblyIdentifier);
    }

    public MotifRegistryBuilder defineByFileAndAssemblyId(InputStream inputStream, String assemblyIdentifier) {
        Structure structure = this.structureDataProvider.readFromInputStream(inputStream);
        return this.defineByStructureAndAssemblyId(structure, assemblyIdentifier);
    }

    public MotifRegistryBuilder defineByStructureAndAssemblyId(Structure structure, String assemblyIdentifier) {
        String structureIdentifier = structure.getStructureIdentifier().toUpperCase();
        ResidueGraph residueGraph = new ResidueGraph(structure, this.strucmotifConfig, ResidueGraph.ResidueGraphOptions.assembly(assemblyIdentifier));
        SingleStructureInvertedIndex invertedIndex = new SingleStructureInvertedIndex(residueGraph);
        SingleStructureIndexProvider structureIndexProvider = new SingleStructureIndexProvider(structure);
        SingleStructureDataProvider structureDataProvider = new SingleStructureDataProvider(structure);
        return new MotifRegistryBuilder(structureIdentifier, structure, invertedIndex, structureIndexProvider, structureDataProvider);
    }

    public class MotifRegistryBuilder {
        private final String structureIdentifier;
        private final Structure structure;
        private final InvertedIndex invertedIndex;
        private final StructureIndexProvider structureIndexProvider;
        private final StructureDataProvider structureDataProvider;

        MotifRegistryBuilder(String structureIdentifier, Structure structure, InvertedIndex invertedIndex, StructureIndexProvider structureIndexProvider, StructureDataProvider structureDataProvider) {
            this.structureIdentifier = structureIdentifier;
            this.structure = structure;
            this.invertedIndex = invertedIndex;
            this.structureIndexProvider = structureIndexProvider;
            this.structureDataProvider = structureDataProvider;
        }

        public MandatoryBuilderStep withMotifs(Set<EnrichedMotifDefinition> motifDefinitions) {
            return new MandatoryBuilderStep(this.structureIdentifier, this.structure, motifDefinitions, this.invertedIndex, this.structureIndexProvider, this.structureDataProvider);
        }
    }

    public class OptionalBuilderStep
    implements ContextBuilder.OptionalBuilder<MotifSearchContext> {
        private final String structureIdentifier;
        private final Structure structure;
        private final Set<EnrichedMotifDefinition> motifDefinitions;
        private final InvertedIndex invertedIndex;
        private final StructureIndexProvider structureIndexProvider;
        private final StructureDataProvider structureDataProvider;
        private final MotifParameters parameters;

        OptionalBuilderStep(String structureIdentifier, Structure structure, Set<EnrichedMotifDefinition> motifDefinitions, InvertedIndex invertedIndex, StructureIndexProvider structureIndexProvider, StructureDataProvider structureDataProvider, MotifParameters parameters) {
            this.structureIdentifier = structureIdentifier;
            this.structure = structure;
            this.motifDefinitions = motifDefinitions;
            this.invertedIndex = invertedIndex;
            this.structureIndexProvider = structureIndexProvider;
            this.structureDataProvider = structureDataProvider;
            this.parameters = parameters;
        }

        @Override
        public MotifSearchContext buildContext() {
            MotifSearchQuery query = new MotifSearchQuery(this.structureIdentifier, this.structure, this.motifDefinitions, this.parameters);
            return new MotifSearchContext(MotifContextBuilder.this.strucmotifRuntime, MotifContextBuilder.this.strucmotifConfig, this.invertedIndex, this.structureIndexProvider, this.structureDataProvider, query);
        }
    }

    public class MandatoryBuilderStep
    implements ContextBuilder.MandatoryBuilder<MotifSearchContext> {
        private final String structureIdentifier;
        private final Structure structure;
        private final Set<EnrichedMotifDefinition> motifDefinitions;
        private final InvertedIndex invertedIndex;
        private final StructureIndexProvider structureIndexProvider;
        private final StructureDataProvider structureDataProvider;
        private int backboneDistanceTolerance;
        private int sideChainDistanceTolerance;
        private int angleTolerance;
        private float rmsdCutoff;
        private AtomPairingScheme atomPairingScheme;
        private MotifPruner motifPruner;

        MandatoryBuilderStep(String structureIdentifier, Structure structure, Set<EnrichedMotifDefinition> motifDefinitions, InvertedIndex invertedIndex, StructureIndexProvider structureIndexProvider, StructureDataProvider structureDataProvider) {
            this.structureIdentifier = structureIdentifier;
            this.structure = structure;
            this.motifDefinitions = motifDefinitions;
            this.invertedIndex = invertedIndex;
            this.structureIndexProvider = structureIndexProvider;
            this.structureDataProvider = structureDataProvider;
            this.backboneDistanceTolerance = 1;
            this.sideChainDistanceTolerance = 1;
            this.angleTolerance = 1;
            this.rmsdCutoff = Float.MAX_VALUE;
            this.atomPairingScheme = AtomPairingScheme.SIDE_CHAIN;
            this.motifPruner = MotifContextBuilder.this.kruskalMotifPruner;
        }

        public MandatoryBuilderStep backboneDistanceTolerance(int backboneDistanceTolerance) {
            this.backboneDistanceTolerance = backboneDistanceTolerance;
            return this;
        }

        public MandatoryBuilderStep sideChainDistanceTolerance(int sideChainDistanceTolerance) {
            this.sideChainDistanceTolerance = sideChainDistanceTolerance;
            return this;
        }

        public MandatoryBuilderStep angleTolerance(int angleTolerance) {
            this.angleTolerance = angleTolerance;
            return this;
        }

        public MandatoryBuilderStep rmsdCutoff(double rmsdCutoff) {
            this.rmsdCutoff = (float)rmsdCutoff;
            return this;
        }

        public MandatoryBuilderStep atomPairingScheme(AtomPairingScheme atomPairingScheme) {
            this.atomPairingScheme = atomPairingScheme;
            return this;
        }

        public MandatoryBuilderStep motifPruningStrategy(MotifPruner motifPruner) {
            this.motifPruner = motifPruner;
            return this;
        }

        public MandatoryBuilderStep motifPruningStrategy(MotifPruningStrategy motifPruningStrategy) {
            switch (motifPruningStrategy) {
                case KRUSKAL: {
                    this.motifPruner = MotifContextBuilder.this.kruskalMotifPruner;
                    break;
                }
                case NONE: {
                    this.motifPruner = MotifContextBuilder.this.noOperationMotifPruner;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case: " + motifPruningStrategy);
                }
            }
            return this;
        }

        public OptionalBuilderStep buildParameters() {
            MotifParameters parameters = new MotifParameters(this.backboneDistanceTolerance, this.sideChainDistanceTolerance, this.angleTolerance, this.rmsdCutoff, this.atomPairingScheme, this.motifPruner);
            return new OptionalBuilderStep(this.structureIdentifier, this.structure, this.motifDefinitions, this.invertedIndex, this.structureIndexProvider, this.structureDataProvider, parameters);
        }
    }
}

