/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.query;

import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.config.MotifPruningStrategy;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.core.IllegalQueryDefinitionException;
import org.rcsb.strucmotif.core.KruskalMotifPruner;
import org.rcsb.strucmotif.core.MotifPruner;
import org.rcsb.strucmotif.core.NoOperationMotifPruner;
import org.rcsb.strucmotif.core.StrucmotifRuntime;
import org.rcsb.strucmotif.domain.StructureSearchContext;
import org.rcsb.strucmotif.domain.align.AtomPairingScheme;
import org.rcsb.strucmotif.domain.motif.MotifDefinition;
import org.rcsb.strucmotif.domain.query.ContextBuilder;
import org.rcsb.strucmotif.domain.query.PositionSpecificExchange;
import org.rcsb.strucmotif.domain.query.ResultsContentType;
import org.rcsb.strucmotif.domain.query.StructureParameters;
import org.rcsb.strucmotif.domain.query.StructureQuery;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.InvertedIndex;
import org.rcsb.strucmotif.io.StructureDataProvider;
import org.rcsb.strucmotif.io.StructureIndexProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureContextBuilder
implements ContextBuilder {
    private final StructureIndexProvider structureIndexProvider;
    private final StructureDataProvider structureDataProvider;
    private final KruskalMotifPruner kruskalMotifPruner;
    private final NoOperationMotifPruner noOperationMotifPruner;
    private final StrucmotifRuntime strucmotifRuntime;
    private final StrucmotifConfig strucmotifConfig;
    private final InvertedIndex invertedIndex;
    private static final Collection<ResultsContentType> DEFAULT_CONTENT_TYPES = EnumSet.of(ResultsContentType.EXPERIMENTAL, ResultsContentType.COMPUTATIONAL);

    @Autowired
    public StructureContextBuilder(StructureIndexProvider structureIndexProvider, StructureDataProvider structureDataProvider, KruskalMotifPruner kruskalMotifPruner, NoOperationMotifPruner noOperationMotifPruner, StrucmotifRuntime strucmotifRuntime, StrucmotifConfig strucmotifConfig, InvertedIndex invertedIndex) {
        this.structureIndexProvider = structureIndexProvider;
        this.structureDataProvider = structureDataProvider;
        this.kruskalMotifPruner = kruskalMotifPruner;
        this.noOperationMotifPruner = noOperationMotifPruner;
        this.strucmotifRuntime = strucmotifRuntime;
        this.strucmotifConfig = strucmotifConfig;
        this.invertedIndex = invertedIndex;
    }

    public MandatoryBuilderStep defineByPdbIdAndSelection(String structureIdentifier, List<LabelSelection> selection) {
        Structure structure = this.structureDataProvider.readOriginal(structureIdentifier);
        return this.defineByStructureAndSelection(structure, selection);
    }

    public MandatoryBuilderStep defineByFileAndSelection(InputStream inputStream, List<LabelSelection> selection) {
        Structure structure = this.structureDataProvider.readFromInputStream(inputStream);
        return this.defineByStructureAndSelection(structure, selection);
    }

    public MandatoryBuilderStep defineByStructureAndSelection(Structure structure, List<LabelSelection> labelSelections) {
        try {
            List<Map<LabelAtomId, float[]>> residues = structure.manifestResidues(labelSelections);
            if (residues.size() > this.strucmotifConfig.getMaxMotifSize()) {
                throw new IllegalArgumentException("maximum motif size is " + this.strucmotifConfig.getMaxMotifSize() + " - file contains " + residues.size() + " residues");
            }
            String structureIdentifier = structure.getStructureIdentifier().toUpperCase();
            return new MandatoryBuilderStep(structureIdentifier, structure, labelSelections, residues);
        }
        catch (NoSuchElementException e) {
            throw new IllegalQueryDefinitionException(e.getMessage());
        }
    }

    public MandatoryBuilderStep defineByFile(InputStream inputStream) {
        Structure structure = this.structureDataProvider.readFromInputStream(inputStream);
        List<LabelSelection> labelSelections = structure.getLabelSelections().stream().map(l -> new LabelSelection(l.getLabelAsymId(), "1", l.getLabelSeqId())).collect(Collectors.toList());
        return this.defineByStructureAndSelection(structure, labelSelections);
    }

    public MandatoryBuilderStep defineByMotif(MotifDefinition motifDefinition) {
        return this.defineByPdbIdAndSelection(motifDefinition.getStructureIdentifier(), motifDefinition.getLabelSelections()).propagateExchanges(motifDefinition.getPositionSpecificExchanges());
    }

    public class MandatoryBuilderStep
    implements ContextBuilder.MandatoryBuilder<StructureSearchContext> {
        private final String structureIdentifier;
        private final Structure structure;
        private final List<LabelSelection> labelSelections;
        private final List<Map<LabelAtomId, float[]>> residues;
        private int backboneDistanceTolerance;
        private int sideChainDistanceTolerance;
        private int angleTolerance;
        private float rmsdCutoff;
        private AtomPairingScheme atomPairingScheme;
        private MotifPruner motifPruner;
        private int limit;
        private boolean undefinedAssemblies;
        private Set<PositionSpecificExchange> upstreamExchanges;

        MandatoryBuilderStep(String structureIdentifier, Structure structure, List<LabelSelection> labelSelections, List<Map<LabelAtomId, float[]>> residues) {
            this.structureIdentifier = structureIdentifier;
            this.structure = structure;
            this.labelSelections = labelSelections;
            this.residues = residues;
            this.backboneDistanceTolerance = 1;
            this.sideChainDistanceTolerance = 1;
            this.angleTolerance = 1;
            this.rmsdCutoff = Float.MAX_VALUE;
            this.atomPairingScheme = AtomPairingScheme.SIDE_CHAIN;
            this.motifPruner = StructureContextBuilder.this.kruskalMotifPruner;
            this.limit = Integer.MAX_VALUE;
            this.undefinedAssemblies = false;
        }

        public MandatoryBuilderStep backboneDistanceTolerance(int backboneDistanceTolerance) {
            this.backboneDistanceTolerance = backboneDistanceTolerance;
            return this;
        }

        public MandatoryBuilderStep sideChainDistanceTolerance(int sideChainDistanceTolerance) {
            this.sideChainDistanceTolerance = sideChainDistanceTolerance;
            return this;
        }

        public MandatoryBuilderStep angleTolerance(int angleTolerance) {
            this.angleTolerance = angleTolerance;
            return this;
        }

        public MandatoryBuilderStep rmsdCutoff(double rmsdCutoff) {
            this.rmsdCutoff = (float)rmsdCutoff;
            return this;
        }

        public MandatoryBuilderStep atomPairingScheme(AtomPairingScheme atomPairingScheme) {
            this.atomPairingScheme = atomPairingScheme;
            return this;
        }

        public MandatoryBuilderStep motifPruningStrategy(MotifPruner motifPruner) {
            this.motifPruner = motifPruner;
            return this;
        }

        public MandatoryBuilderStep motifPruningStrategy(MotifPruningStrategy motifPruningStrategy) {
            switch (motifPruningStrategy) {
                case KRUSKAL: {
                    this.motifPruner = StructureContextBuilder.this.kruskalMotifPruner;
                    break;
                }
                case NONE: {
                    this.motifPruner = StructureContextBuilder.this.noOperationMotifPruner;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case: " + motifPruningStrategy);
                }
            }
            return this;
        }

        public MandatoryBuilderStep limitResults(int limit) {
            this.limit = limit;
            return this;
        }

        public MandatoryBuilderStep undefinedAssemblies(boolean undefinedAssemblies) {
            this.undefinedAssemblies = undefinedAssemblies;
            return this;
        }

        MandatoryBuilderStep propagateExchanges(Set<PositionSpecificExchange> upstreamExchanges) {
            this.upstreamExchanges = upstreamExchanges;
            return this;
        }

        public OptionalBuilderStep buildParameters() {
            StructureParameters parameters = new StructureParameters(this.backboneDistanceTolerance, this.sideChainDistanceTolerance, this.angleTolerance, this.rmsdCutoff, this.atomPairingScheme, this.motifPruner, this.limit, this.undefinedAssemblies);
            return new OptionalBuilderStep(this.structureIdentifier, this.structure, this.labelSelections, this.residues, parameters, this.upstreamExchanges);
        }
    }

    public class OptionalBuilderStep
    implements ContextBuilder.OptionalBuilder<StructureSearchContext> {
        private final String structureIdentifier;
        private final Structure structure;
        private final List<LabelSelection> labelSelections;
        private final List<Map<LabelAtomId, float[]>> residues;
        private final StructureParameters parameters;
        private final Map<LabelSelection, Set<ResidueType>> exchanges;
        private final Set<String> allowedStructures;
        private final Set<String> excludedStructures;
        private Collection<ResultsContentType> resultsContentType;

        OptionalBuilderStep(String structureIdentifier, Structure structure, List<LabelSelection> labelSelections, List<Map<LabelAtomId, float[]>> residues, StructureParameters parameters, Set<PositionSpecificExchange> upstreamExchanges) {
            this.structureIdentifier = structureIdentifier;
            this.structure = structure;
            this.labelSelections = labelSelections;
            this.residues = residues;
            this.parameters = parameters;
            this.exchanges = upstreamExchanges == null || upstreamExchanges.isEmpty() ? new HashMap<LabelSelection, Set<ResidueType>>() : this.explodeExchanges(upstreamExchanges);
            this.allowedStructures = new HashSet<String>();
            this.excludedStructures = new HashSet<String>();
            this.resultsContentType = DEFAULT_CONTENT_TYPES;
        }

        private Map<LabelSelection, Set<ResidueType>> explodeExchanges(Set<PositionSpecificExchange> exchanges) {
            return exchanges.stream().collect(Collectors.toMap(PositionSpecificExchange::getLabelSelection, PositionSpecificExchange::getResidueTypes));
        }

        public OptionalBuilderStep addPositionSpecificExchange(LabelSelection labelSelection, Collection<ResidueType> residueTypes) {
            Set exchange = this.exchanges.computeIfAbsent(labelSelection, k -> new LinkedHashSet());
            exchange.addAll(residueTypes);
            return this;
        }

        public OptionalBuilderStep allowedStructures(Collection<String> structureIdentifiers) {
            this.allowedStructures.addAll(structureIdentifiers);
            return this;
        }

        public OptionalBuilderStep excludedStructures(Collection<String> structureIdentifiers) {
            this.excludedStructures.addAll(structureIdentifiers);
            return this;
        }

        public OptionalBuilderStep resultsContentType(Collection<ResultsContentType> resultsContentType) {
            if (resultsContentType.isEmpty()) {
                throw new IllegalArgumentException("Results content types cannot be empty!");
            }
            this.resultsContentType = resultsContentType;
            return this;
        }

        public OptionalBuilderStep resultsContentType(ResultsContentType first, ResultsContentType ... rest) {
            this.resultsContentType = EnumSet.of(first, rest);
            return this;
        }

        @Override
        public StructureSearchContext buildContext() {
            StructureQuery query = new StructureQuery(this.structureIdentifier, this.structure, this.labelSelections, this.residues, this.parameters, this.exchanges, this.allowedStructures, this.excludedStructures, this.resultsContentType, StructureContextBuilder.this.strucmotifConfig);
            return new StructureSearchContext(StructureContextBuilder.this.strucmotifRuntime, StructureContextBuilder.this.strucmotifConfig, StructureContextBuilder.this.invertedIndex, StructureContextBuilder.this.structureIndexProvider, StructureContextBuilder.this.structureDataProvider, query);
        }
    }
}

