/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.query;

import org.rcsb.strucmotif.core.MotifPruner;
import org.rcsb.strucmotif.domain.align.AtomPairingScheme;
import org.rcsb.strucmotif.domain.query.Parameters;

public class StructureParameters
implements Parameters {
    private final int backboneDistanceTolerance;
    private final int sideChainDistanceTolerance;
    private final int angleTolerance;
    private final float rmsdCutoff;
    private final AtomPairingScheme atomPairingScheme;
    private final MotifPruner motifPruner;
    private final int limit;
    private final boolean undefinedAssemblies;

    public StructureParameters(int backboneDistanceTolerance, int sideChainDistanceTolerance, int angleTolerance, float rmsdCutoff, AtomPairingScheme atomPairingScheme, MotifPruner motifPruner, int resultLimit, boolean undefinedAssemblies) {
        this.backboneDistanceTolerance = backboneDistanceTolerance;
        this.sideChainDistanceTolerance = sideChainDistanceTolerance;
        this.angleTolerance = angleTolerance;
        this.rmsdCutoff = rmsdCutoff;
        this.atomPairingScheme = atomPairingScheme;
        this.motifPruner = motifPruner;
        this.limit = resultLimit;
        this.undefinedAssemblies = undefinedAssemblies;
    }

    public int getBackboneDistanceTolerance() {
        return this.backboneDistanceTolerance;
    }

    public int getSideChainDistanceTolerance() {
        return this.sideChainDistanceTolerance;
    }

    public int getAngleTolerance() {
        return this.angleTolerance;
    }

    public float getRmsdCutoff() {
        return this.rmsdCutoff;
    }

    public boolean hasRmsdCutoff() {
        return this.rmsdCutoff != Float.MAX_VALUE;
    }

    public AtomPairingScheme getAtomPairingScheme() {
        return this.atomPairingScheme;
    }

    public MotifPruner getMotifPruner() {
        return this.motifPruner;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit != Integer.MAX_VALUE;
    }

    public boolean isUndefinedAssemblies() {
        return this.undefinedAssemblies;
    }
}

