/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.query;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.domain.motif.ResiduePairOccurrence;
import org.rcsb.strucmotif.domain.query.ResultsContentType;
import org.rcsb.strucmotif.domain.query.SearchQuery;
import org.rcsb.strucmotif.domain.query.StructureParameters;
import org.rcsb.strucmotif.domain.query.StructureQueryStructure;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueGraph;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.domain.structure.Structure;

public class StructureQuery
implements SearchQuery<StructureParameters, StructureQueryStructure> {
    private final StructureQueryStructure queryStructure;
    private final StructureParameters parameters;
    private final Map<LabelSelection, Set<ResidueType>> exchanges;
    private final Collection<String> allowedStructures;
    private final Collection<String> excludedStructures;
    private final Collection<ResultsContentType> resultsContentType;

    public StructureQuery(String structureIdentifier, Structure structure, List<LabelSelection> labelSelections, List<Map<LabelAtomId, float[]>> residues, StructureParameters parameters, Map<LabelSelection, Set<ResidueType>> exchanges, Collection<String> allowedStructures, Collection<String> excludedStructures, Collection<ResultsContentType> resultsContentType, StrucmotifConfig strucmotifConfig) {
        ResidueGraph residueGraph = new ResidueGraph(structure, labelSelections, residues, strucmotifConfig);
        List<ResiduePairOccurrence> residuePairOccurrences = parameters.getMotifPruner().prune(residueGraph);
        this.queryStructure = new StructureQueryStructure(structureIdentifier, structure, labelSelections, residues, residuePairOccurrences, exchanges);
        this.parameters = parameters;
        this.exchanges = exchanges;
        this.allowedStructures = allowedStructures;
        this.excludedStructures = excludedStructures;
        this.resultsContentType = resultsContentType;
    }

    @Override
    public StructureQueryStructure getQueryStructure() {
        return this.queryStructure;
    }

    @Override
    public StructureParameters getParameters() {
        return this.parameters;
    }

    public Map<LabelSelection, Set<ResidueType>> getExchanges() {
        return this.exchanges;
    }

    public Collection<String> getAllowedStructures() {
        return this.allowedStructures;
    }

    public Collection<String> getExcludedStructures() {
        return this.excludedStructures;
    }

    public Collection<ResultsContentType> getResultsContentType() {
        return this.resultsContentType;
    }
}

