/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.core.IllegalQueryDefinitionException;
import org.rcsb.strucmotif.domain.motif.ResiduePairDescriptor;
import org.rcsb.strucmotif.domain.motif.ResiduePairIdentifier;
import org.rcsb.strucmotif.domain.motif.ResiduePairOccurrence;
import org.rcsb.strucmotif.domain.query.QueryStructure;
import org.rcsb.strucmotif.domain.structure.IndexSelection;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.domain.structure.Structure;

public class StructureQueryStructure
implements QueryStructure {
    private final String structureIdentifier;
    private final Structure structure;
    private final List<IndexSelection> indexSelections;
    private final List<Map<LabelAtomId, float[]>> residues;
    private final List<ResiduePairOccurrence> residuePairOccurrences;
    private final List<ResiduePairIdentifier> residuePairIdentifiers;
    private final List<ResiduePairDescriptor> residuePairDescriptors;
    private final List<Integer> residueIndexSwaps;

    public StructureQueryStructure(String structureIdentifier, Structure structure, List<LabelSelection> originalLabelSelections, List<Map<LabelAtomId, float[]>> originalResidues, List<ResiduePairOccurrence> residuePairOccurrences, Map<LabelSelection, Set<ResidueType>> exchanges) {
        this.structureIdentifier = structureIdentifier;
        this.structure = structure;
        if (residuePairOccurrences.isEmpty()) {
            throw new IllegalQueryDefinitionException("Did not find any residue pairs in structure - check query definition");
        }
        List<ResiduePairOccurrence> connectedResiduePairs = this.getPathOfConnectedResiduePairs(residuePairOccurrences, exchanges);
        this.residuePairOccurrences = connectedResiduePairs;
        this.residuePairIdentifiers = connectedResiduePairs.stream().map(ResiduePairOccurrence::getResidueIdentifier).collect(Collectors.toList());
        this.residuePairDescriptors = connectedResiduePairs.stream().map(ResiduePairOccurrence::getResiduePairDescriptor).collect(Collectors.toList());
        this.indexSelections = this.residuePairIdentifiers.stream().flatMap(ResiduePairIdentifier::indexSelections).distinct().collect(Collectors.toList());
        if (this.indexSelections.size() != originalResidues.size()) {
            throw new IllegalQueryDefinitionException("Query violates distance threshold");
        }
        List originalIndexSelections = originalLabelSelections.stream().map(labelSelection -> {
            int residueIndex = structure.getResidueIndex(labelSelection.getLabelAsymId(), labelSelection.getLabelSeqId());
            return new IndexSelection(labelSelection.getStructOperId(), residueIndex);
        }).collect(Collectors.toList());
        this.residueIndexSwaps = originalIndexSelections.stream().map(this.indexSelections::indexOf).collect(Collectors.toList());
        this.residues = originalResidues;
    }

    private List<ResiduePairOccurrence> getPathOfConnectedResiduePairs(List<ResiduePairOccurrence> residuePairOccurrences, Map<LabelSelection, Set<ResidueType>> exchanges) {
        Map exchangeCounts = residuePairOccurrences.stream().map(ResiduePairOccurrence::getResidueIdentifier).flatMap(ResiduePairIdentifier::indexSelections).distinct().collect(Collectors.toMap(Function.identity(), i -> this.exchangeCount((IndexSelection)i, exchanges)));
        Map connectionCounts = residuePairOccurrences.stream().map(ResiduePairOccurrence::getResidueIdentifier).flatMap(ResiduePairIdentifier::indexSelections).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        ArrayList<ResiduePairOccurrence> sparse = new ArrayList<ResiduePairOccurrence>();
        List sorted = residuePairOccurrences.stream().sorted(Comparator.comparingInt(o -> (Integer)exchangeCounts.get(o.getResidueIdentifier().getIndexSelection1()) + (Integer)exchangeCounts.get(o.getResidueIdentifier().getIndexSelection2())).thenComparing(o -> (Long)connectionCounts.get(o.getResidueIdentifier().getIndexSelection1()) + (Long)connectionCounts.get(o.getResidueIdentifier().getIndexSelection2()))).collect(Collectors.toList());
        sparse.add((ResiduePairOccurrence)sorted.remove(0));
        block0: while (!sorted.isEmpty()) {
            for (int i2 = 0; i2 < sorted.size(); ++i2) {
                ResiduePairOccurrence candidateResiduePair = (ResiduePairOccurrence)sorted.get(i2);
                ResiduePairIdentifier candidateIdentifier = candidateResiduePair.getResidueIdentifier();
                if (!sparse.stream().anyMatch(sortedResiduePair -> this.match(sortedResiduePair.getResidueIdentifier(), candidateIdentifier))) continue;
                sparse.add((ResiduePairOccurrence)sorted.remove(i2));
                continue block0;
            }
        }
        return sparse;
    }

    private int exchangeCount(IndexSelection indexSelection, Map<LabelSelection, Set<ResidueType>> exchanges) {
        LabelSelection l = this.structure.getLabelSelection(indexSelection.getIndex());
        LabelSelection labelSelection = new LabelSelection(l.getLabelAsymId(), indexSelection.getStructOperId(), l.getLabelSeqId());
        return exchanges.containsKey(labelSelection) ? exchanges.get(labelSelection).size() : 0;
    }

    private boolean match(ResiduePairIdentifier sortedWordResiduePairIdentifier, ResiduePairIdentifier candidateIdentifier) {
        return sortedWordResiduePairIdentifier.getIndexSelection1().equals(candidateIdentifier.getIndexSelection1()) || sortedWordResiduePairIdentifier.getIndexSelection1().equals(candidateIdentifier.getIndexSelection2()) || sortedWordResiduePairIdentifier.getIndexSelection2().equals(candidateIdentifier.getIndexSelection1()) || sortedWordResiduePairIdentifier.getIndexSelection2().equals(candidateIdentifier.getIndexSelection2());
    }

    @Override
    public String getStructureIdentifier() {
        return this.structureIdentifier;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    public List<ResiduePairOccurrence> getResiduePairOccurrences() {
        return this.residuePairOccurrences;
    }

    public List<ResiduePairIdentifier> getResiduePairIdentifiers() {
        return this.residuePairIdentifiers;
    }

    public List<ResiduePairDescriptor> getResiduePairDescriptors() {
        return this.residuePairDescriptors;
    }

    public List<Map<LabelAtomId, float[]>> getResidues() {
        return this.residues;
    }

    public List<IndexSelection> getIndexSelections() {
        return this.indexSelections;
    }

    public List<Integer> getResidueIndexSwaps() {
        return this.residueIndexSwaps;
    }
}

