/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.result;

import java.util.List;
import org.rcsb.strucmotif.domain.Transformation;
import org.rcsb.strucmotif.domain.result.Hit;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;

public class StructureHit
implements Hit {
    private final String structureIdentifier;
    private final String assemblyIdentifier;
    private final List<LabelSelection> labelSelections;
    private final List<ResidueType> residueTypes;
    private final float rmsd;
    private final Transformation transformation;

    public StructureHit(String structureIdentifier, String assemblyIdentifier, List<LabelSelection> labelSelections, List<ResidueType> residueTypes, float rmsd, Transformation transformation) {
        this.structureIdentifier = structureIdentifier;
        this.assemblyIdentifier = assemblyIdentifier;
        this.labelSelections = labelSelections;
        this.residueTypes = residueTypes;
        this.rmsd = rmsd;
        this.transformation = transformation;
    }

    public String getStructureIdentifier() {
        return this.structureIdentifier;
    }

    public String getAssemblyIdentifier() {
        return this.assemblyIdentifier;
    }

    public List<LabelSelection> getLabelSelections() {
        return this.labelSelections;
    }

    public List<ResidueType> getResidueTypes() {
        return this.residueTypes;
    }

    public float getRootMeanSquareDeviation() {
        return this.rmsd;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public String toString() {
        return "StructureHit{structureIdentifier='" + this.structureIdentifier + "', assemblyIdentifier='" + this.assemblyIdentifier + "', labelSelections=" + this.labelSelections + ", residueTypes=" + this.residueTypes + ", rmsd=" + this.rmsd + ", transformation=" + this.transformation + "}";
    }
}

