/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rcsb.strucmotif.core.HitScorer;
import org.rcsb.strucmotif.core.IllegalQueryDefinitionException;
import org.rcsb.strucmotif.domain.align.AlignmentResult;
import org.rcsb.strucmotif.domain.motif.InvertedIndexResiduePairIdentifier;
import org.rcsb.strucmotif.domain.motif.Overlap;
import org.rcsb.strucmotif.domain.motif.ResiduePairIdentifier;
import org.rcsb.strucmotif.domain.result.StructureHit;
import org.rcsb.strucmotif.domain.structure.IndexSelection;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.AssemblyInformationProvider;

public class TargetStructure {
    private final int structureIndex;
    private List<InvertedIndexResiduePairIdentifier[]> paths;

    public TargetStructure(int structureIndex, InvertedIndexResiduePairIdentifier[] residuePairIdentifiers) {
        this.structureIndex = structureIndex;
        this.paths = new ArrayList<InvertedIndexResiduePairIdentifier[]>(residuePairIdentifiers.length);
        for (InvertedIndexResiduePairIdentifier residuePairIdentifier : residuePairIdentifiers) {
            this.paths.add(new InvertedIndexResiduePairIdentifier[]{residuePairIdentifier});
        }
    }

    public int getNumberOfValidPaths() {
        return this.paths.size();
    }

    public int getStructureIndex() {
        return this.structureIndex;
    }

    public boolean consume(InvertedIndexResiduePairIdentifier[] residuePairIdentifiers, Overlap[] overlapProfile) {
        ArrayList<InvertedIndexResiduePairIdentifier[]> extendedPaths = new ArrayList<InvertedIndexResiduePairIdentifier[]>();
        for (InvertedIndexResiduePairIdentifier candidateResiduePairIdentifier : residuePairIdentifiers) {
            block1: for (InvertedIndexResiduePairIdentifier[] path : this.paths) {
                for (int k = 0; k < overlapProfile.length; ++k) {
                    Overlap queryOverlap = overlapProfile[k];
                    InvertedIndexResiduePairIdentifier previousResiduePairIdentifier = path[k];
                    if (!queryOverlap.test(previousResiduePairIdentifier, candidateResiduePairIdentifier)) continue block1;
                }
                InvertedIndexResiduePairIdentifier[] extendedPath = Arrays.copyOf(path, path.length + 1);
                extendedPath[path.length] = candidateResiduePairIdentifier;
                extendedPaths.add(extendedPath);
            }
        }
        this.paths = extendedPaths;
        return !this.paths.isEmpty();
    }

    public Stream<StructureHit> paths(List<Integer> residueIndexSwaps, Structure structure, String structureIdentifier, HitScorer hitScorer, float rmsdCutoff, AssemblyInformationProvider assemblyInformationProvider, boolean undefinedAssemblies) {
        return this.paths.stream().flatMap(p -> this.createHits((ResiduePairIdentifier[])p, residueIndexSwaps, structure, structureIdentifier, hitScorer, rmsdCutoff, assemblyInformationProvider, undefinedAssemblies));
    }

    private Stream<StructureHit> createHits(ResiduePairIdentifier[] identifiers, List<Integer> residueIndexSwaps, Structure structure, String structureIdentifier, HitScorer hitScorer, float rmsdCutoff, AssemblyInformationProvider assemblyInformationProvider, boolean undefinedAssemblies) {
        Map<String, Long> assemblyCounts;
        List<IndexSelection> indexSelections = this.orderIndexSelections(identifiers, residueIndexSwaps);
        List labelSelections = indexSelections.stream().map(indexSelection -> {
            LabelSelection labelSelection = structure.getLabelSelection(indexSelection.getIndex());
            return new LabelSelection(labelSelection.getLabelAsymId(), indexSelection.getStructOperId(), labelSelection.getLabelSeqId());
        }).collect(Collectors.toList());
        int residueCount = labelSelections.size();
        Map<String, Set<String>> assemblyMap = assemblyInformationProvider.selectAssemblyMap(structureIdentifier);
        if (assemblyMap.isEmpty()) {
            if (!undefinedAssemblies) {
                return Stream.empty();
            }
            assemblyCounts = Map.of(assemblyInformationProvider.getUndefinedAssemblyIdentifier(), Long.valueOf(residueCount));
        } else {
            assemblyCounts = labelSelections.stream().map(labelSelection -> labelSelection.getLabelAsymId() + "_" + labelSelection.getStructOperId()).map(assemblyMap::get).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        }
        return assemblyCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() == (long)residueCount).map(entry -> {
            ResidueType[] residueTypes = new ResidueType[residueCount];
            Map[] residues = new Map[residueCount];
            for (int i = 0; i < residueCount; ++i) {
                IndexSelection indexSelection = (IndexSelection)indexSelections.get(i);
                int index = indexSelection.getIndex();
                residueTypes[i] = structure.getResidueType(index);
                residues[i] = structure.manifestResidue(index, indexSelection.getStructOperId());
            }
            AlignmentResult alignmentResult = hitScorer.alignToReference(Arrays.asList(residues));
            if (alignmentResult.getRootMeanSquareDeviation() >= rmsdCutoff) {
                return null;
            }
            return new StructureHit(structureIdentifier, (String)entry.getKey(), labelSelections, Arrays.asList(residueTypes), alignmentResult.getRootMeanSquareDeviation(), alignmentResult.getTransformation());
        }).filter(Objects::nonNull);
    }

    private List<IndexSelection> orderIndexSelections(ResiduePairIdentifier[] identifiers, List<Integer> residueIndexSwaps) {
        try {
            List shuffledIndexSelections = Arrays.stream(identifiers).flatMap(ResiduePairIdentifier::indexSelections).distinct().collect(Collectors.toList());
            return residueIndexSwaps.stream().map(shuffledIndexSelections::get).collect(Collectors.toList());
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalQueryDefinitionException("Query violates distance threshold");
        }
    }
}

