/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.result;

import java.util.concurrent.TimeUnit;

public class Timer {
    private long start;
    private long time;
    private boolean stopped;

    public void start() {
        if (this.start != 0L) {
            throw new IllegalStateException("timer has been started before");
        }
        if (this.time != 0L) {
            throw new IllegalStateException("timer has been stopped before");
        }
        this.start = System.nanoTime();
    }

    public void stop() {
        if (this.start == 0L) {
            throw new IllegalStateException("timer was never started");
        }
        if (this.time != 0L) {
            throw new IllegalStateException("timer has been stopped before");
        }
        this.time = System.nanoTime() - this.start;
        this.stopped = true;
    }

    public long getMillisecondTime() {
        return this.getMeasuredTime(TimeUnit.MILLISECONDS);
    }

    public long getMeasuredTime(TimeUnit timeUnit) {
        if (!this.stopped) {
            throw new IllegalStateException("timer was never stopped");
        }
        return timeUnit.convert(this.time, TimeUnit.NANOSECONDS);
    }
}

