/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.schema.mm.MmCifBlock;
import org.rcsb.cif.schema.mm.MmCifFile;
import org.rcsb.cif.schema.mm.PdbxStructAssemblyGen;

public class AssemblyInformation {
    private static final Pattern OPERATION_PATTERN = Pattern.compile("\\)\\(");
    private static final Pattern LIST_PATTERN = Pattern.compile(",");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final Pattern RANGE_PATTERN = Pattern.compile("-");

    public static Map<String, String[]> of(MmCifFile mmCifFile) {
        PdbxStructAssemblyGen pdbxStructAssemblyGen = ((MmCifBlock)mmCifFile.getFirstBlock()).getPdbxStructAssemblyGen();
        HashMap<String, Set> assemblyInformation = new HashMap<String, Set>();
        if (pdbxStructAssemblyGen.isDefined()) {
            for (int i = 0; i < pdbxStructAssemblyGen.getRowCount(); ++i) {
                String assemblyId = pdbxStructAssemblyGen.getAssemblyId().get(i);
                String operExpression = pdbxStructAssemblyGen.getOperExpression().get(i);
                String asymIdList = pdbxStructAssemblyGen.getAsymIdList().get(i);
                List<String> operList = AssemblyInformation.getOperList(operExpression, asymIdList);
                Set sorted = assemblyInformation.computeIfAbsent(assemblyId, e -> new HashSet());
                sorted.addAll(operList);
            }
        }
        return assemblyInformation.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (String[])((Set)v.getValue()).toArray(String[]::new)));
    }

    private static List<String> getOperList(String operExpression, String asymIdList) {
        ArrayList<String> operations = new ArrayList<String>();
        List chains = LIST_PATTERN.splitAsStream(asymIdList).collect(Collectors.toList());
        String[] split = OPERATION_PATTERN.split(operExpression);
        if (split.length > 1) {
            List<String> ids1 = AssemblyInformation.extractTransformationIds(split[0]);
            List<String> ids2 = AssemblyInformation.extractTransformationIds(split[1]);
            for (String id1 : ids1) {
                for (String id2 : ids2) {
                    for (String chain : chains) {
                        operations.add(chain + "_" + id1 + "x" + id2);
                    }
                }
            }
        } else {
            for (String id : AssemblyInformation.extractTransformationIds(operExpression)) {
                for (String chain : chains) {
                    operations.add(chain + "_" + id);
                }
            }
        }
        return operations;
    }

    private static List<String> extractTransformationIds(String rawOperation) {
        String prepared = rawOperation.replace("(", "").replace(")", "").replace("'", "");
        return COMMA_PATTERN.splitAsStream(prepared).flatMap(AssemblyInformation::extractTransformationRanges).collect(Collectors.toList());
    }

    private static Stream<String> extractTransformationRanges(String raw) {
        String[] s = RANGE_PATTERN.split(raw);
        if (s.length == 1) {
            return Stream.of(raw);
        }
        return IntStream.range(Integer.parseInt(s[0]), Integer.parseInt(s[1]) + 1).mapToObj(String::valueOf);
    }
}

