/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.structure;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum PolymerType {
    AMINO_ACID(Set.of("d-peptide linking", "d-peptide nh3 amino terminus", "d-peptide cooh carboxy terminus", "d-gamma-peptide, c-delta linking", "d-beta-peptide, c-gamma linking", "l-peptide linking", "l-peptide nh3 amino terminus", "l-peptide cooh carboxy terminus", "l-gamma-peptide, c-delta linking", "l-beta-peptide, c-gamma linking", "peptide linking", "peptide-like")),
    NUCLEOTIDE(Set.of("dna linking", "l-dna linking", "dna oh 5 prime terminus", "dna oh 3 prime terminus", "rna linking", "l-rna linking", "rna oh 5 prime terminus", "rna oh 3 prime terminus")),
    UNKNOWN_POLYMER(Collections.emptySet());

    private final Set<String> typeNames;
    private static final Map<String, PolymerType> MAPPING;

    private PolymerType(Set<String> typeNames) {
        this.typeNames = typeNames;
    }

    public Set<String> getTypeNames() {
        return this.typeNames;
    }

    public static Optional<PolymerType> ofChemCompType(String type) {
        return Optional.ofNullable(MAPPING.get(type.toLowerCase()));
    }

    static {
        MAPPING = Arrays.stream(PolymerType.values()).flatMap(t -> t.getTypeNames().stream().map(n -> Map.entry(n, t))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

