/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.structure;

import java.util.ArrayList;
import java.util.List;
import org.rcsb.strucmotif.math.Algebra;

public class ResidueGrid {
    private static final int SCALE = 100;
    private final float squaredCutoff;
    private final int cellSize;
    private final List<float[]> vectors;
    private final BoundingBox boundingBox;
    private final int[] intBounds;
    private final ResidueGridCell[][][] gridCells;

    public ResidueGrid(List<float[]> vectors, float squaredCutoff) {
        this.vectors = vectors;
        this.squaredCutoff = squaredCutoff;
        this.cellSize = (int)Math.floor(Math.sqrt(squaredCutoff) * 100.0);
        this.boundingBox = new BoundingBox();
        this.intBounds = this.boundingBox.getIntBounds();
        this.gridCells = new ResidueGridCell[1 + (this.intBounds[3] - this.intBounds[0]) / this.cellSize][1 + (this.intBounds[4] - this.intBounds[1]) / this.cellSize][1 + (this.intBounds[5] - this.intBounds[2]) / this.cellSize];
        this.fillGrid();
    }

    private void fillGrid() {
        int i = -1;
        for (float[] v : this.vectors) {
            ++i;
            if (v == null) continue;
            this.assignCoordsToGridCell(v, i);
        }
    }

    private void assignCoordsToGridCell(float[] coords, int i) {
        int zind;
        int yind;
        int xind = this.xintgrid2xgridindex(this.getFloor(coords[0]));
        if (this.gridCells[xind][yind = this.yintgrid2ygridindex(this.getFloor(coords[1]))][zind = this.zintgrid2zgridindex(this.getFloor(coords[2]))] == null) {
            this.gridCells[xind][yind][zind] = new ResidueGridCell();
        }
        this.gridCells[xind][yind][zind].addIndex(i);
    }

    private int xintgrid2xgridindex(int x) {
        return (x - this.intBounds[0]) / this.cellSize;
    }

    private int yintgrid2ygridindex(int y) {
        return (y - this.intBounds[1]) / this.cellSize;
    }

    private int zintgrid2zgridindex(int z) {
        return (z - this.intBounds[2]) / this.cellSize;
    }

    private int getFloor(float number) {
        return this.cellSize * (int)Math.floor(number * 100.0f / (float)this.cellSize);
    }

    public List<ResidueContact> getIndicesContacts() {
        ArrayList<ResidueContact> contacts = new ArrayList<ResidueContact>();
        for (int xind = 0; xind < this.gridCells.length; ++xind) {
            for (int yind = 0; yind < this.gridCells[xind].length; ++yind) {
                for (int zind = 0; zind < this.gridCells[xind][yind].length; ++zind) {
                    ResidueGridCell thisCell = this.gridCells[xind][yind][zind];
                    if (thisCell == null) continue;
                    contacts.addAll(thisCell.getContactsWithinGridCell());
                    for (int x = xind - 1; x <= xind + 1; ++x) {
                        for (int y = yind - 1; y <= yind + 1; ++y) {
                            for (int z = zind - 1; z <= zind + 1; ++z) {
                                if (x == xind && y == yind && z == zind || x < 0 || x >= this.gridCells.length || y < 0 || y >= this.gridCells[x].length || z < 0 || z >= this.gridCells[x][y].length || this.gridCells[x][y][z] == null) continue;
                                contacts.addAll(thisCell.getContactsToGridCell(this.gridCells[x][y][z]));
                            }
                        }
                    }
                }
            }
        }
        return contacts;
    }

    class BoundingBox {
        final float xmin;
        final float xmax;
        final float ymin;
        final float ymax;
        final float zmin;
        final float zmax;

        public BoundingBox() {
            float xmin = Float.MAX_VALUE;
            float xmax = -3.4028235E38f;
            float ymin = Float.MAX_VALUE;
            float ymax = -3.4028235E38f;
            float zmin = Float.MAX_VALUE;
            float zmax = -3.4028235E38f;
            for (float[] v : ResidueGrid.this.vectors) {
                if (v == null) continue;
                if (v[0] > xmax) {
                    xmax = v[0];
                }
                if (v[0] < xmin) {
                    xmin = v[0];
                }
                if (v[1] > ymax) {
                    ymax = v[1];
                }
                if (v[1] < ymin) {
                    ymin = v[1];
                }
                if (v[2] > zmax) {
                    zmax = v[2];
                }
                if (!(v[2] < zmin)) continue;
                zmin = v[2];
            }
            this.xmin = xmin;
            this.xmax = xmax;
            this.ymin = ymin;
            this.ymax = ymax;
            this.zmin = zmin;
            this.zmax = zmax;
        }

        public int[] getIntBounds() {
            return new int[]{ResidueGrid.this.getFloor(ResidueGrid.this.boundingBox.xmin), ResidueGrid.this.getFloor(ResidueGrid.this.boundingBox.ymin), ResidueGrid.this.getFloor(ResidueGrid.this.boundingBox.zmin), ResidueGrid.this.getFloor(ResidueGrid.this.boundingBox.xmax), ResidueGrid.this.getFloor(ResidueGrid.this.boundingBox.ymax), ResidueGrid.this.getFloor(ResidueGrid.this.boundingBox.zmax)};
        }
    }

    class ResidueGridCell {
        private final List<Integer> indices = new ArrayList<Integer>();

        public void addIndex(int index) {
            this.indices.add(index);
        }

        public List<ResidueContact> getContactsWithinGridCell() {
            return this.getContactsToGridCell(this);
        }

        private List<ResidueContact> getContactsToGridCell(ResidueGridCell other) {
            ArrayList<ResidueContact> contacts = new ArrayList<ResidueContact>();
            for (int i : this.indices) {
                for (int j : other.indices) {
                    float squaredDistance;
                    if (j <= i || !((squaredDistance = Algebra.distanceSquared3d(ResidueGrid.this.vectors.get(i), ResidueGrid.this.vectors.get(j))) < ResidueGrid.this.squaredCutoff)) continue;
                    contacts.add(new ResidueContact(i, j, (float)Math.sqrt(squaredDistance)));
                }
            }
            return contacts;
        }
    }

    static class ResidueContact {
        private final int i;
        private final int j;
        private final float distance;

        public ResidueContact(int i, int j, float distance) {
            this.i = i;
            this.j = j;
            this.distance = distance;
        }

        public int getI() {
            return this.i;
        }

        public int getJ() {
            return this.j;
        }

        public float getDistance() {
            return this.distance;
        }
    }
}

