/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.structure;

import org.rcsb.strucmotif.domain.structure.PolymerType;

public enum ResidueType {
    ALANINE("ALA", "A", PolymerType.AMINO_ACID),
    CYSTEINE("CYS", "C", PolymerType.AMINO_ACID),
    ASPARTIC_ACID("ASP", "D", PolymerType.AMINO_ACID),
    GLUTAMIC_ACID("GLU", "E", PolymerType.AMINO_ACID),
    PHENYLALANINE("PHE", "F", PolymerType.AMINO_ACID),
    GLYCINE("GLY", "G", PolymerType.AMINO_ACID),
    HISTIDINE("HIS", "H", PolymerType.AMINO_ACID),
    ISOLEUCINE("ILE", "I", PolymerType.AMINO_ACID),
    LYSINE("LYS", "K", PolymerType.AMINO_ACID),
    LEUCINE("LEU", "L", PolymerType.AMINO_ACID),
    METHIONINE("MET", "M", PolymerType.AMINO_ACID),
    ASPARAGINE("ASN", "N", PolymerType.AMINO_ACID),
    PYRROLYSINE("PYL", "O", PolymerType.AMINO_ACID),
    PROLINE("PRO", "P", PolymerType.AMINO_ACID),
    GLUTAMINE("GLN", "Q", PolymerType.AMINO_ACID),
    ARGININE("ARG", "R", PolymerType.AMINO_ACID),
    SERINE("SER", "S", PolymerType.AMINO_ACID),
    THREONINE("THR", "T", PolymerType.AMINO_ACID),
    SELENOCYSTEINE("SEC", "U", PolymerType.AMINO_ACID),
    VALINE("VAL", "V", PolymerType.AMINO_ACID),
    TRYPTOPHAN("TRP", "W", PolymerType.AMINO_ACID),
    TYROSINE("TYR", "Y", PolymerType.AMINO_ACID),
    DEOXYADENOSINE("DA", "0", PolymerType.NUCLEOTIDE),
    DEOXYCYTIDINE("DC", "1", PolymerType.NUCLEOTIDE),
    DEOXYGUANOSINE("DG", "2", PolymerType.NUCLEOTIDE),
    DEOXYINOSINE("DI", "3", PolymerType.NUCLEOTIDE),
    DEOXYTHYMIDINE("DT", "4", PolymerType.NUCLEOTIDE),
    DEOXYURIDINE("DU", "5", PolymerType.NUCLEOTIDE),
    ADENOSINE("A", "6", PolymerType.NUCLEOTIDE),
    CYTIDINE("C", "7", PolymerType.NUCLEOTIDE),
    GUANOSINE("G", "8", PolymerType.NUCLEOTIDE),
    INOSINIC_ACID("I", "9", PolymerType.NUCLEOTIDE),
    URIDINE("U", "B", PolymerType.NUCLEOTIDE),
    UNKNOWN_AMINO_ACID("UNK", "J", PolymerType.AMINO_ACID),
    UNKNOWN_NUCLEOTIDE("N", "X", PolymerType.NUCLEOTIDE),
    UNKNOWN_COMPONENT("?", "Z", PolymerType.UNKNOWN_POLYMER);

    private final String threeLetterCode;
    private final String internalCode;
    private final PolymerType polymerType;

    private ResidueType(String threeLetterCode, String internalCode, PolymerType polymerType) {
        this.threeLetterCode = threeLetterCode;
        this.internalCode = internalCode;
        this.polymerType = polymerType;
    }

    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public String getInternalCode() {
        return this.internalCode;
    }

    public PolymerType getPolymerType() {
        return this.polymerType;
    }
}

