/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.structure;

import java.util.Objects;
import org.rcsb.cif.schema.mm.MmCifBlock;
import org.rcsb.cif.schema.mm.MmCifFile;
import org.rcsb.cif.schema.mm.PdbxAuditRevisionHistory;

public class Revision {
    private final int major;
    private final int minor;

    public Revision(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public Revision(MmCifFile mmCifFile) {
        PdbxAuditRevisionHistory pdbxAuditRevisionHistory = ((MmCifBlock)mmCifFile.getFirstBlock()).getPdbxAuditRevisionHistory();
        int last = pdbxAuditRevisionHistory.getRowCount() - 1;
        this.major = pdbxAuditRevisionHistory.getMajorRevision().get(last);
        this.minor = pdbxAuditRevisionHistory.getMinorRevision().get(last);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Revision revision = (Revision)o;
        return this.major == revision.major && this.minor == revision.minor;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }
}

