/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.domain.structure;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.rcsb.strucmotif.domain.Transformation;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.ResidueType;

public class Structure {
    private final String structureIdentifier;
    private final String[] chainIds;
    private final int[] chainOffsets;
    private final short[] labelSeqId;
    private final int chainCount;
    private final int residueCount;
    private final int atomCount;
    private final int[] residueOffsets;
    private final byte[] residueTypes;
    private final byte[] labelAtomId;
    private final short[] x;
    private final short[] y;
    private final short[] z;
    private final String[] assemblyIds;
    private final String[][] chainsReferencedByAssembly;
    private final String[] transformationIds;
    private final Transformation[] transformations;

    public Structure(String structureIdentifier, String[] chainIds, int[] chainOffsets, short[] labelSeqId, int[] residueOffsets, byte[] residueTypes, byte[] labelAtomId, short[] x, short[] y, short[] z, String[] assemblyIds, String[][] chainsReferencedByAssembly, String[] transformationIds, Transformation[] transformations) {
        this.structureIdentifier = structureIdentifier;
        this.chainIds = chainIds;
        this.chainOffsets = chainOffsets;
        this.labelSeqId = labelSeqId;
        this.residueOffsets = residueOffsets;
        this.residueTypes = residueTypes;
        this.chainCount = chainIds.length;
        this.residueCount = residueOffsets.length;
        this.atomCount = labelAtomId.length;
        this.labelAtomId = labelAtomId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.assemblyIds = assemblyIds;
        this.chainsReferencedByAssembly = chainsReferencedByAssembly;
        this.transformationIds = transformationIds;
        this.transformations = transformations;
    }

    private int indexOf(String[] values, String v) {
        Objects.requireNonNull(v);
        for (int i = 0; i < values.length; ++i) {
            if (!v.equals(values[i])) continue;
            return i;
        }
        return -1;
    }

    public String getStructureIdentifier() {
        return this.structureIdentifier;
    }

    public List<LabelSelection> getLabelSelections() {
        return IntStream.range(0, this.residueCount).mapToObj(this::getLabelSelection).collect(Collectors.toList());
    }

    public int getResidueIndex(String labelAsymId, int labelSeqId) {
        int chainIndex = this.indexOf(this.chainIds, labelAsymId);
        if (chainIndex == -1) {
            throw new NoSuchElementException("Didn't find chain: " + labelAsymId);
        }
        int chainStart = this.chainOffsets[chainIndex];
        int chainEnd = this.chainOffsets[chainIndex + 1];
        int index = Arrays.binarySearch(this.labelSeqId, chainStart, chainEnd, (short)labelSeqId);
        if (index < 0) {
            throw new NoSuchElementException("Didn't find residue with label_seq_id " + labelSeqId + " in chain " + labelAsymId);
        }
        return index;
    }

    public LabelSelection getLabelSelection(int residueIndex) {
        int chainIndex = -1;
        for (int i = 0; i < this.chainIds.length; ++i) {
            if (residueIndex < this.chainOffsets[i] || residueIndex > this.chainOffsets[i + 1]) continue;
            chainIndex = i;
        }
        if (chainIndex == -1) {
            throw new NoSuchElementException("Didn't find chain in '" + this.structureIdentifier + "' that contains residue index: " + residueIndex + " - Chain offsets: " + Arrays.toString(this.chainIds) + " -> " + Arrays.toString(this.chainOffsets) + "\n");
        }
        String labelAsymId = this.chainIds[chainIndex];
        short labelSeqId = this.labelSeqId[residueIndex];
        return new LabelSelection(labelAsymId, null, labelSeqId);
    }

    public int getChainCount() {
        return this.chainCount;
    }

    public int getResidueCount() {
        return this.residueCount;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public ResidueType getResidueType(int residueIndex) {
        return ResidueType.values()[this.residueTypes[residueIndex]];
    }

    public Map<String, String[]> getAssemblies() {
        LinkedHashMap<String, String[]> assemblies = new LinkedHashMap<String, String[]>();
        for (int i = 0; i < this.assemblyIds.length; ++i) {
            assemblies.put(this.assemblyIds[i], this.chainsReferencedByAssembly[i]);
        }
        return assemblies;
    }

    public Map<String, Transformation> getTransformations() {
        LinkedHashMap<String, Transformation> transformations = new LinkedHashMap<String, Transformation>();
        for (int i = 0; i < this.transformationIds.length; ++i) {
            transformations.put(this.transformationIds[i], this.transformations[i]);
        }
        return transformations;
    }

    public Transformation getTransformation(String structOperIdentifier) {
        int transformationIndex = this.indexOf(this.transformationIds, structOperIdentifier);
        return this.transformations[transformationIndex];
    }

    public Map<LabelAtomId, float[]> manifestResidue(LabelSelection labelSelection) {
        return this.manifestResidue(this.getResidueIndex(labelSelection.getLabelAsymId(), labelSelection.getLabelSeqId()), labelSelection.getStructOperId());
    }

    public List<Map<LabelAtomId, float[]>> manifestResidues(List<LabelSelection> labelSelections) {
        return labelSelections.stream().map(this::manifestResidue).collect(Collectors.toList());
    }

    public Map<LabelAtomId, float[]> manifestResidue(int residueIndex) {
        return this.manifestResidue(residueIndex, "1");
    }

    public Map<LabelAtomId, float[]> manifestResidue(int residueIndex, String structOperIdentifier) {
        EnumMap<LabelAtomId, float[]> out = new EnumMap<LabelAtomId, float[]>(LabelAtomId.class);
        int offsetStart = this.residueOffsets[residueIndex];
        int offsetEnd = residueIndex + 1 == this.residueOffsets.length ? this.labelAtomId.length : this.residueOffsets[residueIndex + 1];
        int transformationIndex = this.indexOf(this.transformationIds, structOperIdentifier);
        Transformation transformation = transformationIndex == -1 ? Transformation.IDENTITY_TRANSFORMATION : this.transformations[transformationIndex];
        for (int i = offsetStart; i < offsetEnd; ++i) {
            LabelAtomId labelAtomId = LabelAtomId.values()[this.labelAtomId[i]];
            if (labelAtomId == LabelAtomId.UNKNOWN_ATOM) continue;
            float[] v = new float[]{(float)this.x[i] * 0.1f, (float)this.y[i] * 0.1f, (float)this.z[i] * 0.1f};
            transformation.transform(v, v);
            out.put(labelAtomId, v);
        }
        return out;
    }
}

