/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.domain.Pair;
import org.rcsb.strucmotif.domain.structure.StructureInformation;
import org.rcsb.strucmotif.io.AssemblyInformationProvider;
import org.rcsb.strucmotif.io.StateRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssemblyInformationProviderImpl
implements AssemblyInformationProvider {
    private static final Map<String, Set<String>> UNDEFINED_ASSEMBLIES = Collections.emptyMap();
    private final Map<String, Map<String, Set<String>>> reverseAssemblyInformation;
    private final StrucmotifConfig strucmotifConfig;

    @Autowired
    public AssemblyInformationProviderImpl(StateRepository stateRepository, StrucmotifConfig strucmotifConfig) {
        this.reverseAssemblyInformation = this.loadAssemblyInformation(stateRepository);
        this.strucmotifConfig = strucmotifConfig;
    }

    private Map<String, Map<String, Set<String>>> loadAssemblyInformation(StateRepository stateRepository) {
        Collection<StructureInformation> data = stateRepository.selectKnown();
        return data.stream().map(s -> {
            String structureIdentifier = s.getStructureIdentifier();
            Map<String, String[]> assemblyInformation = s.getAssemblyInformation();
            HashMap<String, Set> reversed = new HashMap<String, Set>();
            for (Map.Entry<String, String[]> partial : assemblyInformation.entrySet()) {
                String assemblyId = partial.getKey();
                for (String structOperId : partial.getValue()) {
                    Set mappedAssemblyIds = reversed.computeIfAbsent(structOperId, e -> new HashSet());
                    mappedAssemblyIds.add(assemblyId);
                }
            }
            if (reversed.isEmpty()) {
                return null;
            }
            return new Pair(structureIdentifier, reversed);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    public Map<String, Set<String>> selectAssemblyMap(String structureIdentifier) {
        return this.reverseAssemblyInformation.getOrDefault(structureIdentifier, UNDEFINED_ASSEMBLIES);
    }

    @Override
    public String getUndefinedAssemblyIdentifier() {
        return this.strucmotifConfig.getUndefinedAssemblyIdentifier();
    }
}

