/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.schema.StandardSchemata;
import org.rcsb.cif.schema.mm.ChemComp;
import org.rcsb.cif.schema.mm.MmCifBlock;
import org.rcsb.cif.schema.mm.MmCifFile;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.domain.structure.PolymerType;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.io.ResidueTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResidueTypeResolverImpl
implements ResidueTypeResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResidueTypeResolverImpl.class);
    private static final String MAPPING_FILE = "residue-type-mapping.json";
    private static final Map<String, ResidueType> THREE_LETTER_CODE_MAPPING = Arrays.stream(ResidueType.values()).collect(Collectors.toMap(ResidueType::getThreeLetterCode, Function.identity()));
    private static final Map<String, ResidueType> D_AMINO_ACID_MAPPING = Map.ofEntries(Map.entry("DAL", ResidueType.ALANINE), Map.entry("DAR", ResidueType.ARGININE), Map.entry("DSG", ResidueType.ASPARAGINE), Map.entry("DAS", ResidueType.ASPARTIC_ACID), Map.entry("DCY", ResidueType.CYSTEINE), Map.entry("DGL", ResidueType.GLUTAMIC_ACID), Map.entry("DGN", ResidueType.GLUTAMINE), Map.entry("DHI", ResidueType.HISTIDINE), Map.entry("DIL", ResidueType.ISOLEUCINE), Map.entry("DLE", ResidueType.LEUCINE), Map.entry("DLY", ResidueType.LYSINE), Map.entry("MED", ResidueType.METHIONINE), Map.entry("DPN", ResidueType.PHENYLALANINE), Map.entry("DPR", ResidueType.PROLINE), Map.entry("DSN", ResidueType.SERINE), Map.entry("DTH", ResidueType.THREONINE), Map.entry("DTR", ResidueType.TRYPTOPHAN), Map.entry("DTY", ResidueType.TYROSINE), Map.entry("DVA", ResidueType.VALINE), Map.entry("DNE", ResidueType.LEUCINE));
    private final Map<String, ResidueType> mapping;
    private static final String MAPPING_FILE_PATH = "strucmotif-search-core/src/main/resources/residue-type-mapping.json";

    public static void main(String[] args) throws IOException {
        ResidueTypeResolverImpl.updateResidueTypeMappingFile();
    }

    public ResidueTypeResolverImpl(StrucmotifConfig strucmotifConfig) {
        this.mapping = this.initialize(strucmotifConfig);
        logger.info("modified-residue-strategy is '{}', {} chemical components are mapped to {} residue-types", new Object[]{strucmotifConfig.getModifiedResidueStrategy(), this.mapping.keySet().size(), this.mapping.values().stream().distinct().count()});
    }

    private Map<String, ResidueType> initialize(StrucmotifConfig strucmotifConfig) {
        HashMap<String, ResidueType> out = new HashMap<String, ResidueType>();
        switch (strucmotifConfig.getModifiedResidueStrategy()) {
            case NONE: {
                break;
            }
            case INTERNAL: {
                out.putAll(ResidueTypeResolverImpl.readResidueTypeMappingFile());
                break;
            }
            case CCD_PARENT: {
                out.putAll(ResidueTypeResolverImpl.createCcdMapping(strucmotifConfig.getCcdUrl()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(strucmotifConfig.getModifiedResidueStrategy() + " isn't implemented");
            }
        }
        if (strucmotifConfig.isSupportDAminoAcids()) {
            out.putAll(D_AMINO_ACID_MAPPING);
        }
        out.putAll(THREE_LETTER_CODE_MAPPING);
        return out;
    }

    @Override
    public ResidueType selectResidueType(String threeLetterCode) {
        return this.mapping.getOrDefault(threeLetterCode, ResidueType.UNKNOWN_COMPONENT);
    }

    private static Optional<ResidueType> ofThreeLetterCode(String threeLetterCode) {
        return Optional.ofNullable(THREE_LETTER_CODE_MAPPING.get(threeLetterCode));
    }

    private static Map<String, ResidueType> readResidueTypeMappingFile() {
        Map<String, ResidueType> map;
        block8: {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(MAPPING_FILE);
            try {
                Objects.requireNonNull(inputStream, "residue-type-mapping.json isn't available!");
                Map map2 = (Map)GsonHolder.instance.fromJson((Reader)new InputStreamReader(inputStream), MapTypeHolder.instance);
                map = map2.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ResidueTypeResolverImpl.ofThreeLetterCode((String)e.getValue()).orElseThrow())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            inputStream.close();
        }
        return map;
    }

    private static Map<String, ResidueType> createCcdMapping(String ccdUrl) {
        try {
            logger.info("Reading CCD from {}", (Object)ccdUrl);
            List blocks = ((MmCifFile)CifIO.readFromURL((URL)new URL(ccdUrl)).as(StandardSchemata.MMCIF)).getBlocks();
            HashMap<String, ResidueType> map = new HashMap<String, ResidueType>();
            for (MmCifBlock block : blocks) {
                Optional<ResidueType> parentType;
                ChemComp chemComp = block.getChemComp();
                if (chemComp.getMonNstdParentCompId().getValueKind(0) != ValueKind.PRESENT || PolymerType.ofChemCompType(chemComp.getType().get(0)).isEmpty()) continue;
                String parent = chemComp.getMonNstdParentCompId().get(0).toUpperCase().split(",")[0];
                if (ResidueTypeResolverImpl.ofThreeLetterCode(parent).isEmpty() && D_AMINO_ACID_MAPPING.containsKey(parent)) {
                    parent = D_AMINO_ACID_MAPPING.get(parent).getThreeLetterCode();
                }
                if ((parentType = ResidueTypeResolverImpl.ofThreeLetterCode(parent)).isEmpty()) continue;
                map.put(chemComp.getId().get(0), parentType.get());
            }
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void updateResidueTypeMappingFile() throws IOException {
        String ccdUrl = new StrucmotifConfig().getCcdUrl();
        Map<String, String> ccdMapping = ResidueTypeResolverImpl.createCcdMapping(ccdUrl).entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((ResidueType)((Object)((Object)entry.getValue()))).getThreeLetterCode())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String output = new GsonBuilder().setPrettyPrinting().create().toJson(ccdMapping);
        Files.write(Paths.get(MAPPING_FILE_PATH, new String[0]), output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    static class GsonHolder {
        static final Gson instance = new Gson();

        GsonHolder() {
        }
    }

    static class MapTypeHolder {
        static final Type instance = new TypeToken<Map<String, String>>(){}.getType();

        MapTypeHolder() {
        }
    }
}

