/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import java.util.Collection;
import java.util.Set;
import org.rcsb.strucmotif.domain.query.ResultsContentType;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.StructureIndexProvider;

public class SingleStructureIndexProvider
implements StructureIndexProvider {
    private final int structureIndex;
    private final String structureIdentifier;

    public SingleStructureIndexProvider(Structure structure) {
        this.structureIndex = -1;
        this.structureIdentifier = structure.getStructureIdentifier();
    }

    @Override
    public String selectStructureIdentifier(int structureIndex) {
        return this.structureIdentifier;
    }

    @Override
    public int selectStructureIndex(String structureIdentifier) {
        return this.structureIndex;
    }

    @Override
    public int selectOrMintStructureIndex(String structureIdentifier) {
        throw new UnsupportedOperationException("This index provider is read-only");
    }

    @Override
    public int nextStructureIndex() {
        throw new UnsupportedOperationException("This index provider is read-only");
    }

    @Override
    public boolean containsKey(String structureIdentifier) {
        return this.structureIdentifier.equals(structureIdentifier);
    }

    @Override
    public boolean containsKey(int structureIndex) {
        return this.structureIndex == structureIndex;
    }

    @Override
    public Set<Integer> selectByResultsContentType(Collection<ResultsContentType> resultsContentType) {
        return Set.of(Integer.valueOf(this.structureIndex));
    }
}

