/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.domain.Pair;
import org.rcsb.strucmotif.domain.structure.Revision;
import org.rcsb.strucmotif.domain.structure.StructureInformation;
import org.rcsb.strucmotif.io.StateRepository;
import org.springframework.stereotype.Service;

@Service
public class StateRepositoryImpl
implements StateRepository {
    private static final String TOP_LEVEL_DELIMITER = ",";
    private static final String ASSEMBLY_INFORMATION_DELIMITER = ";";
    private final Path knownPath;
    private final Path dirtyPath;

    public StateRepositoryImpl(StrucmotifConfig strucmotifConfig) {
        Path rootPath = Paths.get(strucmotifConfig.getRootPath(), new String[0]);
        this.knownPath = rootPath.resolve("known.list");
        this.dirtyPath = rootPath.resolve("dirty.list");
    }

    @Override
    public Collection<StructureInformation> selectKnown() {
        Collection collection;
        block8: {
            Stream<String> lines = Files.lines(this.knownPath);
            try {
                collection = lines.filter(line -> !line.isBlank()).map(line -> line.split(TOP_LEVEL_DELIMITER)).map(this::handleKnownSplit).collect(Collectors.toSet());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptySet();
                }
            }
            lines.close();
        }
        return collection;
    }

    protected StructureInformation handleKnownSplit(String[] split) {
        String structureIdentifier = split[0];
        int structureIndex = Integer.parseInt(split[1]);
        Revision revision = new Revision(Integer.parseInt(split[2]), Integer.parseInt(split[3]));
        Map<String, String[]> assemblyInformation = IntStream.range(4, split.length).mapToObj(i -> {
            String[] assemblySplit = split[i].split(ASSEMBLY_INFORMATION_DELIMITER);
            String assemblyId = assemblySplit[0];
            String[] operList = (String[])Arrays.stream(assemblySplit, 1, assemblySplit.length).toArray(String[]::new);
            return new Pair<String, String[]>(assemblyId, operList);
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        return new StructureInformation(structureIdentifier, structureIndex, revision, assemblyInformation);
    }

    @Override
    public Collection<String> selectDirty() {
        if (Files.exists(this.dirtyPath, new LinkOption[0])) {
            return this.select(this.dirtyPath);
        }
        return Collections.emptySet();
    }

    private Set<String> select(Path source) {
        Set<String> set;
        block8: {
            Stream<String> lines = Files.lines(source);
            try {
                set = lines.filter(line -> !line.isBlank()).collect(Collectors.toSet());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptySet();
                }
            }
            lines.close();
        }
        return set;
    }

    @Override
    public void insertKnown(Collection<StructureInformation> additions) {
        try (FileWriter writer = new FileWriter(this.knownPath.toFile(), true);){
            for (StructureInformation addition : additions) {
                String update = addition.getStructureIdentifier() + TOP_LEVEL_DELIMITER + addition.getStructureIndex() + TOP_LEVEL_DELIMITER + addition.getRevision().getMajor() + TOP_LEVEL_DELIMITER + addition.getRevision().getMinor() + TOP_LEVEL_DELIMITER + addition.getAssemblyInformation().entrySet().stream().map(entry -> (String)entry.getKey() + ASSEMBLY_INFORMATION_DELIMITER + String.join((CharSequence)ASSEMBLY_INFORMATION_DELIMITER, (CharSequence[])entry.getValue())).collect(Collectors.joining(TOP_LEVEL_DELIMITER)) + "\n";
                writer.append(update);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void insertDirty(Collection<String> additions) {
        this.insert(additions, this.dirtyPath);
    }

    private void insert(Collection<String> additions, Path destination) {
        try (FileWriter writer = new FileWriter(destination.toFile(), true);){
            for (String structureIdentifier : additions) {
                String update = structureIdentifier + "\n";
                writer.append(update);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void deleteKnown(Collection<String> removals) {
        this.delete(removals, this.knownPath);
    }

    @Override
    public void deleteDirty(Collection<String> removals) {
        if (Files.exists(this.dirtyPath, new LinkOption[0])) {
            this.delete(removals, this.dirtyPath);
        } else {
            try {
                Files.createFile(this.dirtyPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void delete(Collection<String> removals, Path destination) {
        if (!Files.exists(destination, new LinkOption[0])) {
            return;
        }
        try (Stream<String> lines = Files.lines(destination);){
            String output = lines.filter(line -> removals.stream().noneMatch(line::startsWith)).collect(Collectors.joining("\n", "", "\n"));
            Files.write(destination, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

