/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rcsb.strucmotif.domain.query.ResultsContentType;
import org.rcsb.strucmotif.domain.structure.StructureInformation;
import org.rcsb.strucmotif.io.StateRepository;
import org.rcsb.strucmotif.io.StructureIndexProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureIndexProviderImpl
implements StructureIndexProvider {
    private static final Logger logger = LoggerFactory.getLogger(StructureIndexProviderImpl.class);
    private final Deque<Integer> reuse = new ArrayDeque<Integer>();
    private int next;
    private final Map<Integer, String> forward = new HashMap<Integer, String>();
    private final Map<String, Integer> backward = new HashMap<String, Integer>();
    private final Set<Integer> experimental = new HashSet<Integer>();
    private final Set<Integer> computational = new HashSet<Integer>();

    @Autowired
    public StructureIndexProviderImpl(StateRepository stateRepository) {
        int max = -1;
        for (StructureInformation structureInformation : stateRepository.selectKnown()) {
            int structureIndex = structureInformation.getStructureIndex();
            String structureIdentifier = structureInformation.getStructureIdentifier();
            this.forward.put(structureIndex, structureIdentifier);
            this.backward.put(structureIdentifier, structureIndex);
            if (ResultsContentType.EXPERIMENTAL.test(structureIdentifier)) {
                this.experimental.add(structureIndex);
            } else {
                this.computational.add(structureIndex);
            }
            if (structureIndex <= max) continue;
            max = structureIndex;
        }
        this.next = max + 1;
        for (int i = 0; i < this.next; ++i) {
            if (this.forward.containsKey(i)) continue;
            this.reuse.add(i);
        }
        if (this.forward.size() != this.backward.size()) {
            throw new IllegalStateException("Mappings are not bidirectional: " + this.forward.size() + " identifiers, " + this.backward.size() + " indices");
        }
        if (this.containsKey(null)) {
            throw new IllegalStateException("Mappings contain 'null' key");
        }
        logger.info("{} mappings ({} PDB entries, {} computed structure models)", new Object[]{this.forward.size(), this.experimental.size(), this.computational.size()});
        logger.info("{} keys will be reused, after that the next index will be {}", (Object)this.reuse.size(), (Object)this.next);
    }

    @Override
    public String selectStructureIdentifier(int structureIndex) {
        if (!this.containsKey(structureIndex)) {
            throw new IllegalStateException("No value for " + structureIndex + " - perform a 'RECOVER' update to remove lingering structures from index");
        }
        return this.forward.get(structureIndex);
    }

    @Override
    public int selectStructureIndex(String structureIdentifier) {
        return this.backward.get(structureIdentifier);
    }

    @Override
    public int selectOrMintStructureIndex(String structureIdentifier) {
        if (this.backward.containsKey(structureIdentifier)) {
            return this.backward.get(structureIdentifier);
        }
        return this.nextStructureIndex();
    }

    @Override
    public synchronized int nextStructureIndex() {
        if (!this.reuse.isEmpty()) {
            return this.reuse.removeFirst();
        }
        return this.next++;
    }

    @Override
    public boolean containsKey(String structureIdentifier) {
        return this.backward.containsKey(structureIdentifier);
    }

    @Override
    public boolean containsKey(int structureIndex) {
        return this.forward.containsKey(structureIndex);
    }

    @Override
    public Set<Integer> selectByResultsContentType(Collection<ResultsContentType> resultsContentType) {
        if (resultsContentType.contains(ResultsContentType.EXPERIMENTAL) && resultsContentType.contains(ResultsContentType.COMPUTATIONAL)) {
            return this.forward.keySet();
        }
        if (resultsContentType.contains(ResultsContentType.EXPERIMENTAL)) {
            return this.experimental;
        }
        if (resultsContentType.contains(ResultsContentType.COMPUTATIONAL)) {
            return this.computational;
        }
        throw new UnsupportedOperationException(resultsContentType + " isn't handled");
    }
}

