/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.schema.StandardSchemata;
import org.rcsb.cif.schema.mm.AtomSite;
import org.rcsb.cif.schema.mm.MmCifBlock;
import org.rcsb.cif.schema.mm.MmCifFile;
import org.rcsb.cif.schema.mm.PdbxStructAssemblyGen;
import org.rcsb.cif.schema.mm.PdbxStructOperList;
import org.rcsb.strucmotif.domain.Transformation;
import org.rcsb.strucmotif.domain.structure.AssemblyInformation;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.domain.structure.Structure;
import org.rcsb.strucmotif.io.ResidueTypeResolver;
import org.rcsb.strucmotif.io.StructureReader;
import org.rcsb.strucmotif.math.Algebra;
import org.springframework.stereotype.Service;

@Service
public class StructureReaderImpl
implements StructureReader {
    private static final Pattern OPERATION_PATTERN = Pattern.compile("\\)\\(");
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final Pattern RANGE_PATTERN = Pattern.compile("-");
    private final ResidueTypeResolver residueTypeResolver;

    public StructureReaderImpl(ResidueTypeResolver residueTypeResolver) {
        this.residueTypeResolver = residueTypeResolver;
    }

    @Override
    public Structure readFromInputStream(InputStream inputStream) {
        try {
            MmCifFile mmCifFile = (MmCifFile)CifIO.readFromInputStream((InputStream)inputStream).as(StandardSchemata.MMCIF);
            return new StructureReaderState(mmCifFile).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    class StructureReaderState {
        private final MmCifFile mmCifFile;
        private final String structureIdentifier;
        private final AtomSite atomSite;
        private final PdbxStructAssemblyGen pdbxStructAssemblyGen;
        private final PdbxStructOperList pdbxStructOperList;
        private final byte[] labelAtomId;
        private final String[] labelCompId;
        private final String[] labelAsymId;
        private final int[] labelSeqId;
        private final short[] x;
        private final short[] y;
        private final short[] z;
        private String lastLabelAsymId;
        private int lastLabelSeqId;
        private final List<String> chainIds;
        private final List<Integer> chainOffsets;
        private final List<Integer> labelSeqIdCollapsed;
        private final List<Integer> residueOffsets;
        private final List<ResidueType> residueTypes;

        private StructureReaderState(MmCifFile mmCifFile) {
            this.mmCifFile = mmCifFile;
            MmCifBlock block = (MmCifBlock)mmCifFile.getFirstBlock();
            this.structureIdentifier = block.getBlockHeader();
            this.atomSite = block.getAtomSite();
            this.pdbxStructAssemblyGen = block.getPdbxStructAssemblyGen();
            this.pdbxStructOperList = block.getPdbxStructOperList();
            this.labelAtomId = this.convertLabelAtomId((String[])this.atomSite.getLabelAtomId().getArray());
            this.labelCompId = (String[])this.atomSite.getLabelCompId().getArray();
            this.labelAsymId = (String[])this.atomSite.getLabelAsymId().getArray();
            this.labelSeqId = (int[])this.atomSite.getLabelSeqId().getArray();
            this.x = this.convertCoords((double[])this.atomSite.getCartnX().getArray());
            this.y = this.convertCoords((double[])this.atomSite.getCartnY().getArray());
            this.z = this.convertCoords((double[])this.atomSite.getCartnZ().getArray());
            this.lastLabelAsymId = null;
            this.lastLabelSeqId = -1;
            this.chainIds = new ArrayList<String>();
            this.chainOffsets = new ArrayList<Integer>();
            this.labelSeqIdCollapsed = new ArrayList<Integer>();
            this.residueOffsets = new ArrayList<Integer>();
            this.residueTypes = new ArrayList<ResidueType>();
        }

        private short[] convertCoords(double[] array) {
            short[] out = new short[array.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (short)Math.round(array[i] * 10.0);
            }
            return out;
        }

        private byte[] convertLabelAtomId(String[] array) {
            byte[] out = new byte[array.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (byte)LabelAtomId.ofLabelAtomId(array[i]).ordinal();
            }
            return out;
        }

        private byte[] convertResidueTypes(List<ResidueType> residueTypes) {
            byte[] out = new byte[residueTypes.size()];
            for (int i = 0; i < out.length; ++i) {
                out[i] = (byte)residueTypes.get(i).ordinal();
            }
            return out;
        }

        private int[] convertOffsets(List<Integer> offsets) {
            int[] out = new int[offsets.size()];
            for (int i = 0; i < out.length; ++i) {
                out[i] = offsets.get(i);
            }
            return out;
        }

        private short[] convertLabelSeqId(List<Integer> labelSeqIdCollapsed) {
            short[] out = new short[labelSeqIdCollapsed.size()];
            for (int i = 0; i < out.length; ++i) {
                out[i] = labelSeqIdCollapsed.get(i).shortValue();
            }
            return out;
        }

        private String[] convertStrings(List<String> values) {
            String[] out = new String[values.size()];
            for (int i = 0; i < out.length; ++i) {
                out[i] = values.get(i);
            }
            return out;
        }

        private Structure build() {
            int residueIndex = 0;
            for (int row = 0; row < this.atomSite.getRowCount(); ++row) {
                boolean residueChange;
                String labelAsymId = this.labelAsymId[row];
                int labelSeqId = this.labelSeqId[row];
                boolean chainChange = !labelAsymId.equals(this.lastLabelAsymId);
                boolean bl = residueChange = labelSeqId != this.lastLabelSeqId;
                if (chainChange) {
                    this.chainIds.add(labelAsymId);
                    this.chainOffsets.add(residueIndex);
                }
                if (!chainChange && !residueChange) continue;
                this.lastLabelAsymId = labelAsymId;
                this.lastLabelSeqId = labelSeqId;
                this.labelSeqIdCollapsed.add(labelSeqId);
                this.residueOffsets.add(row);
                this.residueTypes.add(StructureReaderImpl.this.residueTypeResolver.selectResidueType(this.labelCompId[row]));
                ++residueIndex;
            }
            this.chainOffsets.add(residueIndex);
            Map<String, Transformation> transformations = this.buildTransformations();
            Map<String, String[]> assemblies = AssemblyInformation.of(this.mmCifFile);
            return new Structure(this.structureIdentifier, this.convertStrings(this.chainIds), this.convertOffsets(this.chainOffsets), this.convertLabelSeqId(this.labelSeqIdCollapsed), this.convertOffsets(this.residueOffsets), this.convertResidueTypes(this.residueTypes), this.labelAtomId, this.x, this.y, this.z, (String[])assemblies.keySet().toArray(String[]::new), (String[][])assemblies.values().toArray(x$0 -> new String[x$0][]), (String[])transformations.keySet().toArray(String[]::new), (Transformation[])transformations.values().toArray(Transformation[]::new));
        }

        private Map<String, Transformation> getTransformations(Map<String, float[][]> transformations, String operations) {
            HashMap<String, Transformation> composedTransformations = new HashMap<String, Transformation>();
            String[] split = OPERATION_PATTERN.split(operations);
            if (split.length > 1) {
                List<String> ids1 = this.extractTransformationIds(split[0]);
                List<String> ids2 = this.extractTransformationIds(split[1]);
                for (String id1 : ids1) {
                    for (String id2 : ids2) {
                        composedTransformations.put(id1 + "x" + id2, Transformation.of(Algebra.multiply4d(transformations.get(id1), transformations.get(id2))));
                    }
                }
            } else {
                List<String> ids = this.extractTransformationIds(operations);
                for (String id : ids) {
                    composedTransformations.put(id, Transformation.of(transformations.get(id)));
                }
            }
            return composedTransformations;
        }

        private List<String> extractTransformationIds(String rawOperation) {
            String prepared = rawOperation.replace("(", "").replace(")", "").replace("'", "");
            return COMMA_PATTERN.splitAsStream(prepared).flatMap(this::extractTransformationRanges).collect(Collectors.toList());
        }

        private Stream<String> extractTransformationRanges(String raw) {
            String[] s = RANGE_PATTERN.split(raw);
            if (s.length == 1) {
                return Stream.of(raw);
            }
            return IntStream.range(Integer.parseInt(s[0]), Integer.parseInt(s[1]) + 1).mapToObj(String::valueOf);
        }

        private Map<String, Transformation> buildTransformations() {
            HashMap<String, Transformation> transformations = new HashMap<String, Transformation>();
            Map<String, float[][]> matrices = IntStream.range(0, this.pdbxStructOperList.getRowCount()).boxed().collect(Collectors.toMap(row -> this.pdbxStructOperList.getId().get(row.intValue()), row -> new float[][]{{(float)this.pdbxStructOperList.getMatrix11().get(row.intValue()), (float)this.pdbxStructOperList.getMatrix12().get(row.intValue()), (float)this.pdbxStructOperList.getMatrix13().get(row.intValue()), (float)this.pdbxStructOperList.getVector1().get(row.intValue())}, {(float)this.pdbxStructOperList.getMatrix21().get(row.intValue()), (float)this.pdbxStructOperList.getMatrix22().get(row.intValue()), (float)this.pdbxStructOperList.getMatrix23().get(row.intValue()), (float)this.pdbxStructOperList.getVector2().get(row.intValue())}, {(float)this.pdbxStructOperList.getMatrix31().get(row.intValue()), (float)this.pdbxStructOperList.getMatrix32().get(row.intValue()), (float)this.pdbxStructOperList.getMatrix33().get(row.intValue()), (float)this.pdbxStructOperList.getVector3().get(row.intValue())}, {0.0f, 0.0f, 0.0f, 1.0f}}));
            if (this.pdbxStructAssemblyGen.isDefined()) {
                for (int row2 = 0; row2 < this.pdbxStructAssemblyGen.getRowCount(); ++row2) {
                    String operExpression = this.pdbxStructAssemblyGen.getOperExpression().get(row2);
                    transformations.putAll(this.getTransformations(matrices, operExpression));
                }
            } else {
                transformations.put("1", Transformation.IDENTITY_TRANSFORMATION);
            }
            return transformations;
        }
    }
}

